/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    12 Mar 2024
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          12 Mar 2024     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#include "main.h"

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

ald_rtc_time_t time;
ald_rtc_date_t date;
ald_rtc_alarm_t alarm;
uint8_t flag = 0;

/**
  * @brief  Test RTC time and date functions
  * @retval Status.
  */
int main()
{
    ald_rtc_init_t init;

    /* Initialize ALD */
    ald_cmu_init();
    /* Configure system clock */
    ald_cmu_pll_config(ALD_CMU_PLL_INPUT_HRC, ALD_CMU_PLL_OUTPUT_48M);
    ald_cmu_clock_config(ALD_CMU_CLOCK_PLL, 48000000);
    /* Set PCLK2 frequency */
    ald_cmu_div_config(ALD_CMU_PCLK_2, ALD_CMU_DIV_4);
    /* Enable all peripherals */
    ald_cmu_perh_clock_config(ALD_CMU_PERH_ALL, ENABLE);
    /* Enable RTC interrupt */
    ald_mcu_irq_config(RTC_IRQn, 0, 3, ENABLE);

    /* Initialize RTC */
    init.asynch_pre_div  = 0;
    init.synch_pre_div   = 32767;
    init.hour_format     = ALD_RTC_HOUR_FORMAT_24;
    init.output          = ALD_RTC_OUTPUT_DISABLE;
    init.output_polarity = ALD_RTC_OUTPUT_POLARITY_HIGH;
    ald_rtc_init(&init);
    ald_cmu_rtc_clock_select(ALD_CMU_RTC_SEL_LRC);

    /* Set current time and date */
    time.hour    = 21;
    time.minute  = 22;
    time.second  = 43;
    date.day     = 11;
    date.month   = 9;
    date.year    = 17;
    date.week    = 1;
    ald_rtc_set_time(&time, ALD_RTC_FORMAT_DEC);
    ald_rtc_set_date(&date, ALD_RTC_FORMAT_DEC);

    /* Enable second interrupt */
    ald_rtc_interrupt_config(ALD_RTC_IT_SEC, ENABLE);

    while (1)
    {
        if (flag == 1)
        {
            flag = 0;
        }
    }
}

/**
  * @brief  RTC IRQ handler
  * @retval None
  */
void rtc_irq_handler(void)
{
    ald_rtc_get_time(&time, ALD_RTC_FORMAT_DEC);
    ald_rtc_get_flag_status(ALD_RTC_IF_SEC);
    ald_rtc_clear_flag_status(ALD_RTC_IF_SEC);
    flag = 1;

    return;
}
/**
  * @}
  */
/**
  * @}
  */
