/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0.1
  * @date    12 Mar 2024
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          12 Mar 2024     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */

#include <string.h>
#include "main.h"

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

ald_lpuart_handle_t h_lpuart;

uint8_t tx_buf[8];
uint8_t rx_buf[8];

/**
  * @brief  Initializate pin of uart module.
  * @retval None
  */
void lpuart_pin_init(void)
{
    ald_gpio_init_t x;

    /* Initialize tx pin */
    x.mode  = ALD_GPIO_MODE_OUTPUT;
    x.odos  = ALD_GPIO_PUSH_PULL;
    x.pupd  = ALD_GPIO_PUSH_UP;
    x.podrv = ALD_GPIO_OUT_DRIVE_1;
    x.nodrv = ALD_GPIO_OUT_DRIVE_1;
    x.flt   = ALD_GPIO_FILTER_DISABLE;
    x.type  = ALD_GPIO_TYPE_TTL;
    x.func  = ALD_GPIO_FUNC_2;
    ald_gpio_init(GPIOA, GPIO_PIN_5, &x);

    /* Initialize rx pin */
    x.mode  = ALD_GPIO_MODE_INPUT;
    x.odos  = ALD_GPIO_PUSH_PULL;
    x.pupd  = ALD_GPIO_PUSH_UP;
    x.podrv = ALD_GPIO_OUT_DRIVE_1;
    x.nodrv = ALD_GPIO_OUT_DRIVE_1;
    x.flt   = ALD_GPIO_FILTER_DISABLE;
    x.type  = ALD_GPIO_TYPE_TTL;
    x.func  = ALD_GPIO_FUNC_2;
    ald_gpio_init(GPIOA, GPIO_PIN_4, &x);
}

/**
  * @brief  Send message complete.
  * @param  arg: Pointer to uart_handle_t structure.
  * @retval None.
  */
void lpuart_send_complete(ald_lpuart_handle_t *arg)
{
    return;
}

/**
  * @brief  Receive a message complete.
  * @param  arg: Pointer to uart_handle_t structure.
  * @retval None.
  */
void lpuart_recv_complete(ald_lpuart_handle_t *arg)
{
    return;
}

/**
  * @brief  Occurs error.
  * @param  arg: Pointer to uart_handle_t structure.
  * @retval None.
  */
void lpuart_error(ald_lpuart_handle_t *arg)
{
    return;
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
    /* Initialize ALD */
    ald_cmu_init();
    ald_cmu_pll_config(ALD_CMU_PLL_INPUT_HRC, ALD_CMU_PLL_OUTPUT_48M);
    ald_cmu_clock_config(ALD_CMU_CLOCK_PLL, 48000000);
    ald_cmu_perh_clock_config(ALD_CMU_PERH_ALL, ENABLE);

    /* clear uart_handle_t structure */
    memset(&h_lpuart, 0x0, sizeof(h_lpuart));

    /* Initialize pin */
    lpuart_pin_init();

    /* Initialize tx_buf */
    memset(tx_buf, 0x55, sizeof(tx_buf));

    /* Initialize uart */
    h_lpuart.perh             = LPUART0;
    h_lpuart.init.baud        = 9600;
    h_lpuart.init.word_length = ALD_LPUART_WORD_LENGTH_8B;
    h_lpuart.init.stop_bits   = ALD_LPUART_STOP_BITS_1;
    h_lpuart.init.parity      = ALD_LPUART_PARITY_NONE;
    h_lpuart.init.mode        = ALD_LPUART_MODE_UART;
    h_lpuart.init.fctl        = ALD_LPUART_HW_FLOW_CTL_NONE;
    h_lpuart.tx_cplt_cbk      = lpuart_send_complete;
    h_lpuart.rx_cplt_cbk      = lpuart_recv_complete;
    h_lpuart.error_cbk        = lpuart_error;
    ald_lpuart_init(&h_lpuart);

    /* Send a message */
    ald_lpuart_send(&h_lpuart, tx_buf, 8, 1000);
    ald_delay_ms(1000);

    /* Receive a message */
    ald_lpuart_recv(&h_lpuart, rx_buf, 8, 10000);

    while (1)
    {
        ald_delay_ms(1000);
        ald_lpuart_send(&h_lpuart, tx_buf, 8, 1000);
    }
}

/**
  * @}
  */
/**
  * @}
  */
