/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    12 Mar 2024
  * @author  AE Team
  * @note
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  *********************************************************************************
  */

#include "main.h"
#include <string.h>


ald_lptim_handle_t h_lptim;

/**
  * @brief  LPTIMER updata complete callback function
  * @retval Status.
  */
void ald_lptim_updata_callback(ald_lptim_handle_t *arg)
{
    ald_gpio_toggle_pin(GPIOA, GPIO_PIN_15);
}

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

void test_gpio_toggle_init(void)
{
	ald_gpio_init_t x;
    
	x.mode  = ALD_GPIO_MODE_OUTPUT;
	x.odos  = ALD_GPIO_PUSH_PULL;
	x.pupd  = ALD_GPIO_PUSH_UP;
	x.podrv = ALD_GPIO_OUT_DRIVE_1;
	x.nodrv = ALD_GPIO_OUT_DRIVE_1;
	x.flt   = ALD_GPIO_FILTER_DISABLE;
	x.type  = ALD_GPIO_TYPE_TTL;
	x.func  = ALD_GPIO_FUNC_1;
	ald_gpio_init(GPIOA, GPIO_PIN_15, &x);

	ald_gpio_write_pin(GPIOA, GPIO_PIN_15, 1);
}


/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
    /* Initialize ALD */
    ald_cmu_init();
    ald_cmu_pll_config(ALD_CMU_PLL_INPUT_HRC, ALD_CMU_PLL_OUTPUT_48M);
    ald_cmu_clock_config(ALD_CMU_CLOCK_PLL, 48000000);
    ald_cmu_perh_clock_config(ALD_CMU_PERH_ALL, ENABLE);

	ald_mcu_irq_config(LP16T0_IRQn, 1, 1, ENABLE);
	ald_cmu_lptim0_clock_select(ALD_CMU_LP_PERH_CLOCK_SEL_LRC);

	test_gpio_toggle_init();
	memset(&h_lptim, 0, sizeof(ald_lptim_handle_t));

	h_lptim.perh       = LPTIM;
	h_lptim.init.arr   = 65535;
	h_lptim.init.clock = ALD_CMU_LP_PERH_CLOCK_SEL_LRC;
	h_lptim.update_cbk = ald_lptim_updata_callback;
	ald_lptim_base_init(&h_lptim);

	ald_lptim_base_start_by_it(&h_lptim);

	while (1) 
    {
		
	}
}

/**
  * @}
  */

/**
  * @}
  */
