/**
  *********************************************************************************
  *
  * @file    main.h
  * @brief   Header file for DEMO
  *
  * @version V1.0
  * @date    12 Mar 2024
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          12 Mar 2024     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#ifndef   __MAIN_H__
#define   __MAIN_H__

#include "ald_conf.h"

#define W25Q32_CS_SET() (ald_gpio_write_pin(GPIOA, GPIO_PIN_4, 1))
#define W25Q32_CS_CLR() (ald_gpio_write_pin(GPIOA, GPIO_PIN_4, 0))

typedef enum w25_status_s
{
    W25_OK    = 0,
    W25_ERROR = 1,
} w25_status_t;

extern void w25q32_module_init(void);
extern w25_status_t w25q32_fast_read(uint32_t addr, uint8_t *buf, uint16_t size);
extern w25_status_t w25q32_read(uint32_t addr, uint8_t *buf, uint16_t size);
extern w25_status_t w25q32_write(uint32_t addr, uint8_t *buf, uint16_t size);
extern w25_status_t w25q32_sector_erase(uint8_t addr);
extern uint32_t meter_bsp_spi_flash_read_id(void);

#endif
