/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    12 Mar 2024
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          12 Mar 2024     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#include <string.h>
#include "main.h"


/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

uint8_t src_buf[32];
uint8_t dst_buf[32];
ald_dma_handle_t hperh;

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
    /* Initialize ALD */
    ald_cmu_init();
    ald_cmu_pll_config(ALD_CMU_PLL_INPUT_HRC, ALD_CMU_PLL_OUTPUT_48M);
    ald_cmu_clock_config(ALD_CMU_CLOCK_PLL, 48000000);
    ald_cmu_perh_clock_config(ALD_CMU_PERH_ALL, ENABLE);

    /* Initialize src_buf, dst_buf */
    memset(src_buf, 0x22, 32);
    memset(dst_buf, 0x77, 32);

    hperh.perh = DMA0;
    ald_dma_config_struct(&hperh);

    hperh.config.src             = src_buf;
    hperh.config.src_data_width  = ALD_DMA_DATA_SIZE_BYTE;
    hperh.config.src_inc         = ALD_DMA_DATA_INC_ENABLE;
    hperh.config.dst             = dst_buf;
    hperh.config.dst_data_width  = ALD_DMA_DATA_SIZE_BYTE;
    hperh.config.dst_inc         = ALD_DMA_DATA_INC_ENABLE;
    hperh.config.mem_to_mem      = ENABLE;

    hperh.config.size          = 32;
    hperh.config.priority      = ALD_DMA_LOW_PRIORITY;
    hperh.config.R_power       = ALD_DMA_R_POWER_2;
    hperh.config.dir           = ALD_DMA_DIR_TO_SRAM;
    hperh.config.circle_mode   = DISABLE;

    hperh.cplt_tc_cbk          = NULL;
    hperh.cplt_tc_arg          = NULL;
    hperh.config.channel       = 0;
    ald_dma_config(&hperh);

    while (1)
    {
        ald_delay_ms(1000);
    }
}

/**
  * @}
  */
/**
  * @}
  */
