/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    12 Mar 2024
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          12 Mar 2024     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#include <string.h>
#include "main.h"



/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

uint32_t dac_value;
ald_dma_handle_t hperh;
ald_dac_handle_t h_dac;
ald_timer_handle_t h_tim;
ald_pis_handle_t h_pis;

const uint16_t sine_wave128[] = {
2047, 2147, 2248, 2347, 2446, 2544, 2641, 2737, 2830, 2922, 3012, 3099,
3184, 3266, 3346, 3422, 3494, 3564, 3629, 3691, 3749, 3803, 3852, 3897,
3938, 3974, 4006, 4033, 4055, 4072, 4084, 4092, 4094, 4092, 4084, 4072,
4055, 4033, 4006, 3974, 3938, 3897, 3852, 3803, 3749, 3691, 3629, 3564,
3494, 3422, 3346, 3266, 3184, 3099, 3012, 2922, 2830, 2737, 2641, 2544,
2446, 2347, 2248, 2147, 2047, 1947, 1846, 1747, 1648, 1550, 1453, 1357,
1264, 1172, 1082, 995 , 910 , 828 , 748 , 672 , 600 , 530 , 465 , 403 ,
345 , 291 , 242 , 197 , 156 , 120 , 88  , 61  , 39  , 22  , 10  , 2   ,
0   , 2   , 10  , 22  , 39  , 61  , 88  , 120 , 156 , 197 , 242 , 291 ,
345 , 403 , 465 , 530 , 600 , 672 , 748 , 828 , 910 , 995 , 1082, 1172,
1264, 1357, 1453, 1550, 1648, 1747, 1846, 1947 };

/**
  * @brief  DAC pin init.
  * @retval None.
  */
void dac_gpio_init(void)
{
    ald_gpio_init_t x;
    memset(&x, 0, sizeof(ald_gpio_init_t));

    x.mode = ALD_GPIO_MODE_OUTPUT;
    x.func = ALD_GPIO_FUNC_0;
    ald_gpio_init(DAC0_OUT_PORT, DAC0_OUT_PIN, &x);
    return;
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
    /* Initialize ALD */
    ald_cmu_init();
    /* Configure system clock */
    ald_cmu_pll_config(ALD_CMU_PLL_INPUT_HRC, ALD_CMU_PLL_OUTPUT_48M);
    ald_cmu_clock_config(ALD_CMU_CLOCK_PLL, 48000000);

    /* Enable mode clock */
    ald_cmu_perh_clock_config(ALD_CMU_PERH_ALL, ENABLE);
    /* DAC pin Initialize */
    dac_gpio_init();

    memset(&h_dac, 0, sizeof(ald_dac_handle_t));

    /* Initialize DAC */
    h_dac.perh               = DAC0;
    h_dac.init.output_mode   = ALD_DAC_OUTPUT_ENHANCE;
    h_dac.init.output_op     = ENABLE;
    h_dac.init.pis_trig      = DISABLE;
    h_dac.init.soft_trig     = ALD_DAC_WR_DBUF_TRG;
    h_dac.init.noise_mode    = ALD_DAC_NWM_None;
    h_dac.init.noise_width   = ALD_DAC_NWBW_1;
    h_dac.init.output_gpio   = ENABLE;
    h_dac.init.align_mode    = ALD_DAC_ALIGN_R12;
    ald_dac_init(&h_dac);
    
    /* DMA config */
    hperh.perh = DMA0;
    ald_dma_config_struct(&hperh);

    hperh.config.src             = (void *)&sine_wave128;
    hperh.config.src_data_width  = ALD_DMA_DATA_SIZE_HALFWORD;
    hperh.config.src_inc         = ALD_DMA_DATA_INC_ENABLE;
    hperh.config.dst             = (void*)&DAC0->R12BUF;
    hperh.config.dst_data_width  = ALD_DMA_DATA_SIZE_HALFWORD;
    hperh.config.dst_inc         = ALD_DMA_DATA_INC_DISABLE;
    hperh.config.mem_to_mem      = DISABLE;

    hperh.config.size          = 128;
    hperh.config.priority      = ALD_DMA_LOW_PRIORITY;
    hperh.config.R_power       = ALD_DMA_R_POWER_2;
    hperh.config.dir           = ALD_DMA_DIR_TO_PERH;
    hperh.config.circle_mode   = ENABLE;
    /* DMA trigger source */
    hperh.config.msel          = ALD_DMA_MSEL_TIMER0;
    hperh.config.msigsel       = ALD_DMA_MSIGSEL_TIMER_UPDATE;

    hperh.cplt_tc_cbk          = NULL;
    hperh.cplt_tc_arg          = NULL;
    hperh.config.channel       = 0;
    ald_dma_config(&hperh);
    
    /* Initialize AD16C4T0 */
    h_tim.perh = AD16C4T0;
    h_tim.init.prescaler    = 47999;
    h_tim.init.mode         = ALD_TIMER_CNT_MODE_UP;
    h_tim.init.period       = 1;
    h_tim.init.clk_div      = ALD_TIMER_CLOCK_DIV1;
    h_tim.init.re_cnt       = 0;
    h_tim.period_elapse_cbk = NULL;
    ald_timer_base_init(&h_tim);
    ald_timer_dma_req_config(&h_tim, ALD_TIMER_DMA_UPDATE, ENABLE);
    ald_timer_base_start(&h_tim);
   
    while (1)
    {

    }
}

/**
  * @}
  */
/**
  * @}
  */
