/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    12 Mar 2024
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          12 Mar 2024     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#include <string.h>
#include "main.h"



/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

uint32_t dac_value;
ald_dac_handle_t h_dac;

/**
  * @brief  DAC pin init.
  * @retval None.
  */
void dac_gpio_init(void)
{
    ald_gpio_init_t x;
    memset(&x, 0, sizeof(ald_gpio_init_t));

    x.mode = ALD_GPIO_MODE_OUTPUT;
    x.func = ALD_GPIO_FUNC_0;
    ald_gpio_init(DAC0_OUT_PORT, DAC0_OUT_PIN, &x);
    return;
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
    /* Initialize ALD */
    ald_cmu_init();
    /* Configure system clock */
    ald_cmu_pll_config(ALD_CMU_PLL_INPUT_HRC, ALD_CMU_PLL_OUTPUT_48M);
    ald_cmu_clock_config(ALD_CMU_CLOCK_PLL, 48000000);

    /* Enable mode clock */
    ald_cmu_perh_clock_config(ALD_CMU_PERH_ALL, ENABLE);
    /* DAC pin Initialize */
    dac_gpio_init();

    memset(&h_dac, 0, sizeof(ald_dac_handle_t));

    /* Initialize DAC */
    h_dac.perh               = DAC0;
    h_dac.init.output_mode   = ALD_DAC_OUTPUT_ENHANCE;
    h_dac.init.output_op     = ENABLE;
    h_dac.init.pis_trig      = DISABLE;
    h_dac.init.soft_trig     = ALD_DAC_WR_DBUF_TRG;
    h_dac.init.noise_mode    = ALD_DAC_NWM_None;
    h_dac.init.noise_width   = ALD_DAC_NWBW_1;
    h_dac.init.output_gpio   = ENABLE;
    h_dac.init.align_mode    = ALD_DAC_ALIGN_R12;
    ald_dac_init(&h_dac);

    /* Set channel 0 output value */
    dac_value = 4095;
    ald_dac_set_value(&h_dac, dac_value);

    while (1)
    {
        ald_delay_ms(200);
        dac_value  = dac_value < 200 ? 4095 : dac_value;
        dac_value -= 200;
        ald_dac_set_value(&h_dac, dac_value);
    }
}

/**
  * @}
  */
/**
  * @}
  */
