/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    12 Mar 2024
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          12 Mar 2024     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#include <string.h>
#include "main.h"


/** @addtogroup Projects_Examples_ALD
  * @{
  */
/** @addtogroup Examples
  * @{
  */
ald_crc_handle_t h_crc;
uint8_t crc_buf[12] = {0};
uint32_t result = 0;

/**
  * @brief  calculate completed callback.
  * @param  arg: Pointer to ald_crc_handle_t structure.
  * @retval None.
  */
void calculate_complete(ald_crc_handle_t *arg)
{
    result = result ^ 0xffff;
    return;
}

/**
  * @brief  calculate error callback.
  * @param  arg: Pointer to ald_crc_handle_t structure.
  * @retval None.
  */
void error_complete(ald_crc_handle_t *arg)
{
    return;
}

/* test case
 * CRC-CCITT DMA   refin ture
 *         refout ture
 *         init 0xffff
 *
 */
void test_crc_dma_test(void)
{
    int32_t i;
    uint8_t crc_buf_temp[11] = {0x19, 0x00, 0x43, 0x05, 0x01, 0x00, 0x00, 0x00, 0x00, 0x17, 0x00};
    /* Clear ald_crc_handle_t structure */
    memset(&h_crc, 0x0, sizeof(ald_crc_handle_t));

    for (i = 0; i < 11; i++)
    {
        crc_buf[i] = crc_buf_temp[i];
    }

    /* Initialize CRC */
    h_crc.perh = CRC;
    h_crc.init.mode = ALD_CRC_MODE_CCITT;
    h_crc.init.seed = 0xffff;
    h_crc.init.data_rev = ENABLE;
    h_crc.init.data_inv = DISABLE;
    h_crc.init.chs_rev = ENABLE;
    h_crc.init.chs_inv = DISABLE;

    h_crc.cal_cplt_cbk = calculate_complete;
    h_crc.err_cplt_cbk = error_complete;
    ald_crc_init(&h_crc);

    /* start calculate by dma and the result is 0x77E3 */
    ald_crc_calculate_by_dma(&h_crc, crc_buf, &result, 11, 1);
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
    /* Initialize ALD */
    ald_cmu_init();
    /* Configure system clock */
    ald_cmu_pll_config(ALD_CMU_PLL_INPUT_HRC, ALD_CMU_PLL_OUTPUT_48M);
    ald_cmu_clock_config(ALD_CMU_CLOCK_PLL, 48000000);
    /* Enable CRC mode clock */
    ald_cmu_perh_clock_config(ALD_CMU_PERH_ALL, ENABLE);

    /* start calculate by dma and right result is 0x77E3*/
    test_crc_dma_test();

    while (1)
    {
        ald_delay_ms(1000);
    }
}

/**
  * @}
  */
/**
  * @}
  */
