/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#include <string.h>
#include <rtthread.h>
#include "main.h"


/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

void test0(void)
{
    rt_kprintf("FinSH test0\n");
    return;
}
MSH_CMD_EXPORT(test0, test to FinSH);

void test1(int argc, char **argv)
{
    if (argc != 2)
    {
        rt_kprintf("Please input 'test1 <server|client>'\n");
        return;
    }

    if (!rt_strcmp(argv[1], "server"))
        rt_kprintf("Server!\n");
    else if (!rt_strcmp(argv[1], "client"))
        rt_kprintf("Client!\n");
    else
        rt_kprintf("Please input 'test1 <server|client>'\n");
}
MSH_CMD_EXPORT(test1, msh_atcmd sample: atcmd < server | client >);

void test2(int argc, char **argv)
{
    int param1, param2;

    if (argc != 3)
    {
        rt_kprintf("Please input 'test2 int int'\n");
        return;
    }

    param1 = atoi(argv[1]);
    param2 = atoi(argv[2]);

    rt_kprintf("First: %s\n", argv[1]);
    rt_kprintf("Second: %s\n", argv[2]);
    rt_kprintf("param1: %d\n", param1);
    rt_kprintf("param2: %d\n", param2);
}
MSH_CMD_EXPORT(test2, msh_atcmd sample: atcmd < server | client >);

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
    return 0;
}

/**
  * @}
  */
/**
  * @}
  */
