#include <stdio.h>
#include <string.h>
#include "main.h"
ald_uart_handle_t g_uart_init;
void init_uart()
{
    ald_gpio_init_t gpio_init;
    memset(&gpio_init, 0x00, sizeof(ald_gpio_init_t));

    /* Initialize tx pin: PB10 */
    gpio_init.mode  = ALD_GPIO_MODE_OUTPUT;
    gpio_init.odos  = ALD_GPIO_PUSH_PULL;
    gpio_init.pupd  = ALD_GPIO_PUSH_UP;
    gpio_init.podrv = ALD_GPIO_OUT_DRIVE_1;
    gpio_init.nodrv = ALD_GPIO_OUT_DRIVE_1;
    gpio_init.flt   = ALD_GPIO_FILTER_DISABLE;
    gpio_init.type  = ALD_GPIO_TYPE_CMOS;
    gpio_init.func  = ALD_GPIO_FUNC_3;
    ald_gpio_init(UART_TX_PORT, UART_TX_PIN, &gpio_init);

    /* Initialize rx pin: PB11 */
    gpio_init.mode  = ALD_GPIO_MODE_INPUT;
    gpio_init.odos  = ALD_GPIO_PUSH_PULL;
    gpio_init.pupd  = ALD_GPIO_PUSH_UP;
    gpio_init.podrv = ALD_GPIO_OUT_DRIVE_1;
    gpio_init.nodrv = ALD_GPIO_OUT_DRIVE_1;
    gpio_init.flt   = ALD_GPIO_FILTER_DISABLE;
    gpio_init.type  = ALD_GPIO_TYPE_CMOS;
    gpio_init.func  = ALD_GPIO_FUNC_3;
    ald_gpio_init(UART_RX_PORT, UART_RX_PIN, &gpio_init);

    memset(&g_uart_init, 0x00, sizeof(ald_uart_handle_t));
    /* Initialize uart */
    g_uart_init.perh             = UART0;
    g_uart_init.init.baud        = 115200;
    g_uart_init.init.word_length = ALD_UART_WORD_LENGTH_8B;
    g_uart_init.init.stop_bits   = ALD_UART_STOP_BITS_1;
    g_uart_init.init.parity      = ALD_UART_PARITY_NONE;
    g_uart_init.init.mode        = ALD_UART_MODE_UART;
    g_uart_init.init.fctl        = ALD_UART_HW_FLOW_CTL_DISABLE;
    g_uart_init.rx_cplt_cbk      = NULL;
    g_uart_init.tx_cplt_cbk      = NULL;
    ald_uart_init(&g_uart_init);

    ald_uart_rx_fifo_config(&g_uart_init, ALD_UART_RXFIFO_1BYTE);
    ald_uart_tx_fifo_config(&g_uart_init, ALD_UART_TXFIFO_EMPTY);
}

int fputc(int ch, FILE *f)
{
    uint8_t c = ch;

    if (ch == '\n')
    {
        uint8_t c2 = '\r';
        ald_uart_send(&g_uart_init, &c2, 1, 1000);
    }

    ald_uart_send(&g_uart_init, &c, 1, 1000);
    return ch;
}

extern int benchmark_coremark_main(void);
int main()
{
    ald_cmu_init();
    ald_cmu_pll_config(ALD_CMU_PLL_INPUT_HOSC_2, ALD_CMU_PLL_OUTPUT_72M);
    ald_cmu_clock_config(ALD_CMU_CLOCK_PLL, 72000000);
    ald_cmu_perh_clock_config(ALD_CMU_PERH_ALL, ENABLE);
    ald_mcu_timestamp_init();

    init_uart();

    printf("Startup...\r\n");
    benchmark_coremark_main();

    while (1);
}
