/**********************************************************************************
 *
 * @file    main.c
 * @brief   ADC_SingleConversion C file
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          2021/09/03      AE              the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */
#include <string.h>
#include "main.h"
#include "los_sys.h"
#include "los_task.ph"
#include "los_memory.h"

/* Private Macros ------------------------------------------------------------ */
/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */

static UINT32 AppTaskCreate(void);
static UINT32 Creat_Test_Task(void);
static void Test_Task(void);
static void BSP_Init(void);

/* Private Variables --------------------------------------------------------- */
/* Public Variables ---------------------------------------------------------- */

UINT32 g_Test_Task_Handle;

/* Private Function ---------------------------------------------------------- */

/***************************************************************
  * @brief  
  * @param  
  * @retval 
  * @note   һӲʼ
            ڶAPPӦ
            LiteOSʼȣʧϢ
  **************************************************************/
int main(void)
{
    UINT32 uwRet = LOS_OK;  /* һ񴴽ķֵĬΪɹ */

    /* سʼ */
    BSP_Init();

    printf("example start\r\n");

    /* LiteOS ں˳ʼ */
    uwRet = LOS_KernelInit();

    if (uwRet != LOS_OK)
    {
        printf("[err]LiteOS core init err! code = 0x%X\r\n", uwRet);
        return LOS_NOK;
    }

    uwRet = AppTaskCreate();

    if (uwRet != LOS_OK)
    {
        printf("[err]AppTaskCreate err! cde = 0x%X\r\n", uwRet);
        return LOS_NOK;
    }

    /* LiteOS */
    LOS_Start();

    /* ²ִе */
    while (1);

}

/*********************************************************************
  * @    AppTaskCreate
  * @ ˵ 񴴽Ϊ˷е񴴽Է
  * @      
  * @ ֵ   
  *******************************************************************/
static UINT32 AppTaskCreate(void)
{
    /* һͱʼΪLOS_OK */
    UINT32 uwRet = LOS_OK;
    uwRet = Creat_Test_Task();

    if (uwRet != LOS_OK)
    {
        printf("Test_Task task creation failed! Failure code = 0x%X\r\n", uwRet);
        return uwRet;
    }

    return LOS_OK;
}

/******************************************************************
  * @    Creat_LED_Task
  * @ ˵ LED_Task
  * @     
  * @ ֵ   
  ******************************************************************/
static UINT32 Creat_Test_Task()
{
    UINT32 uwRet = LOS_OK;              /* һķͣʼΪɹķֵ */
    TSK_INIT_PARAM_S task_init_param;

    task_init_param.usTaskPrio = 4;             /* ȼֵԽСȼԽ */
    task_init_param.pcName = "Test_Task";                       /*  */
    task_init_param.pfnTaskEntry = (TSK_ENTRY_FUNC)Test_Task;   /*  */
    task_init_param.uwStackSize = 1024;                     /* ջС */

    uwRet = LOS_TaskCreate(&g_Test_Task_Handle, &task_init_param);/*  */
    return uwRet;
}

/*********************************************************************************
  * @    Clear_Task
  * @ ˵ дѾʼɹڴصַ
  * @      void
  * @ ֵ   
  ********************************************************************************/
static void Test_Task(void)
{
    UINT32 uwRet = LOS_OK;          /* һʼķͣʼΪɹķֵ */
    printf("\r\nlist init ......\r\n");

    LOS_DL_LIST *head;              /* һ˫ͷڵ */
    head = (LOS_DL_LIST *)LOS_MemAlloc(m_aucSysMem0, sizeof(LOS_DL_LIST));  /* ̬ͷڴ */

    LOS_ListInit(head);             /* ʼ˫ */

    if (!LOS_ListEmpty(head))       /* жǷʼɹ */
    {
        printf("list init fail\r\n");
    }
    else
    {
        printf("list init succes\r\n");
    }

    printf("\r\nAdd node and tail node......\r\n");         /* ڵ㣺˳ĩβ */

    LOS_DL_LIST *node1 = (LOS_DL_LIST *)LOS_MemAlloc(m_aucSysMem0, sizeof(LOS_DL_LIST));/* ̬һڴ */
    LOS_DL_LIST *node2 = (LOS_DL_LIST *)LOS_MemAlloc(m_aucSysMem0, sizeof(LOS_DL_LIST));/* ̬ڶڴ */
    LOS_DL_LIST *tail = (LOS_DL_LIST *)LOS_MemAlloc(m_aucSysMem0, sizeof(LOS_DL_LIST)); /* ̬βڴ */

    printf("Add the first node and the second node.....\r\n");
    LOS_ListAdd(head, node1);                   /* ӵһڵ㣬ͷ */
    LOS_ListAdd(node1, node2);                  /* ӵڶڵ㣬һڵ */

    if ((node1->pstPrev == head) || (node2->pstPrev == node1))  /* жǷɹ */
    {
        printf("add node succes\r\n");
    }
    else
    {
        printf("Failed to add node!\r\n");
    }

    printf("Insert the tail node into the end of the bidirectional linked list.....\r\n");
    LOS_ListTailInsert(head, tail);             /* βڵ˫ĩβ */

    if (tail->pstPrev == node2)                 /* жǷɹ */
    {
        printf("The end node of the linked list was added successfully!\r\n");
    }
    else
    {
        printf("Failed to add end of list node!\r\n");
    }

    printf("\r\nDelete node......\r\n");                /* ɾнڵ */
    LOS_ListDelete(node1);                  /* ɾһڵ */
    LOS_MemFree(m_aucSysMem0, node1);       /* ͷŵһڵڴ棬֤ĳڴռ */

    if (head->pstNext == node2)             /* жǷɾɹ */
    {
        printf("Delete node succes\r\n");
    }
    else
    {
        printf("Delete node fail\r\n");

    }

    while (1)
    {
        DEBUG_LED1_TOGGLE
        DEBUG_LED2_TOGGLE
        printf("Task running!\r\n");
        LOS_TaskDelay(2000);
    }
}


/*******************************************************************
  * @    BSP_Init
  * @ ˵ 弶ʼаϵĳʼɷ
  * @     
  * @ ֵ   
  ******************************************************************/
static void BSP_Init(void)
{
    ald_cmu_init();
    ald_cmu_pll_config(ALD_CMU_PLL_INPUT_HRC, ALD_CMU_PLL_OUTPUT_72M);
    ald_cmu_clock_config(ALD_CMU_CLOCK_PLL, 72000000);
    ald_cmu_perh_clock_config(ALD_CMU_PERH_ALL, ENABLE);
    SysTick->CTRL  &= ~SysTick_CTRL_ENABLE_Msk;

    bsp_led_init();
    bsp_uart_init();
    bsp_key_init();
}

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
