/**********************************************************************************
 *
 * @file    main.c
 * @brief   ADC_SingleConversion C file
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          2021/09/03      AE              the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */
#include <string.h>
#include "main.h"
/* LiteOS ͷļ */
#include "los_sys.h"
#include "los_task.ph"
#include "los_swtmr.h"

/* Private Macros ------------------------------------------------------------ */
/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */

static UINT32 AppTaskCreate(void);
static void Timer1_Callback(UINT32 arg);
static void Timer2_Callback(UINT32 arg);

static void LED_Task(void);
static void Key_Task(void);
static void BSP_Init(void);

/* Private Variables --------------------------------------------------------- */

static UINT32 s_TmrCb_Count1 = 0;
static UINT32 s_TmrCb_Count2 = 0;

/* Public Variables ---------------------------------------------------------- */

/* 嶨ʱID */
UINT16 g_Timer1_Handle;
UINT16 g_Timer2_Handle;

/* Private Function ---------------------------------------------------------- */

/***************************************************************
  * @brief  
  * @param  
  * @retval 
  * @note   һӲʼ
            ڶAPPӦ
            LiteOSʼȣʧϢ
  **************************************************************/
int main(void)
{
    UINT32 uwRet = LOS_OK;  /* һ񴴽ķֵĬΪɹ */

    /* سʼ */
    BSP_Init();

    printf("example start\r\n");

    /* LiteOS ں˳ʼ */
    uwRet = LOS_KernelInit();

    if (uwRet != LOS_OK)
    {
        printf("[err]LiteOS core init err! code = 0x%X\r\n", uwRet);
        return LOS_NOK;
    }

    uwRet = AppTaskCreate();

    if (uwRet != LOS_OK)
    {
        printf("[err]AppTaskCreate err! cde = 0x%X\r\n", uwRet);
        return LOS_NOK;
    }

    /* LiteOS */
    LOS_Start();

    /* ²ִе */
    while (1);

}


/*********************************************************************
  * @    AppTaskCreate
  * @ ˵ 񴴽Ϊ˷е񴴽Է
  * @      
  * @ ֵ   
  *******************************************************************/
static UINT32 AppTaskCreate(void)
{
    /* һͱʼΪLOS_OK */
    UINT32 uwRet = LOS_OK;

    /* һʱ*/
    uwRet = LOS_SwtmrCreate(5000,                   /* ʱĶʱʱ*/
                            LOS_SWTMR_MODE_ONCE,    /* ʱģʽ һģʽ */
                            (SWTMR_PROC_FUNC)Timer1_Callback,       /* ʱĻص */
                            &g_Timer1_Handle,                   /* ʱid */
                            0);

    if (uwRet != LOS_OK)
    {
        printf("Timer1 create err! code = 0x%X\r\n", uwRet);
    }

    uwRet = LOS_SwtmrCreate(1000,                   /* ʱĶʱʱ䣨ms*/
                            LOS_SWTMR_MODE_PERIOD,  /* ʱģʽ ģʽ */
                            (SWTMR_PROC_FUNC)Timer2_Callback,       /* ʱĻص */
                            &g_Timer2_Handle,           /* ʱid */
                            0);

    if (uwRet != LOS_OK)
    {
        printf("Timer2 create err! code = 0x%X\r\n", uwRet);
        return uwRet;
    }

    /* һʱ*/
    uwRet = LOS_SwtmrStart(g_Timer1_Handle);

    if (uwRet != LOS_OK)
    {
        printf("start Timer1 failed\r\n");
        return uwRet;
    }
    else
    {
        printf("start Timer1 sucess\r\n");
    }

    /* һʱ*/
    uwRet = LOS_SwtmrStart(g_Timer2_Handle);

    if (LOS_OK != uwRet)
    {
        printf("start Timer2 failed\r\n");
        return uwRet;
    }
    else
    {
        printf("start Timer2 succes\r\n");
    }

    return LOS_OK;
}

/*********************************************************************************
  * @    Timer1_Callback
  * @ ˵ ʱص1
  * @      1δʹ
  * @ ֵ   
  ********************************************************************************/
static void Timer1_Callback(UINT32 arg)
{
    UINT32 tick_num1;

    s_TmrCb_Count1++;                       /* ÿصһμһ */
    DEBUG_LED1_TOGGLE;
    tick_num1 = (UINT32)LOS_TickCountGet(); /* ȡδʱļֵ */

    printf("Timer_CallBack_Count1=%d\r\n", s_TmrCb_Count1);
    printf("tick_num1=%d\r\n", tick_num1);
}
/*********************************************************************************
  * @    Timer2_Callback
  * @ ˵ ʱص2
  * @      1δʹ
  * @ ֵ   
  ********************************************************************************/
static void Timer2_Callback(UINT32 arg)
{
    UINT32 tick_num2;

    s_TmrCb_Count2++;               /* ÿصһμһ */
    DEBUG_LED2_TOGGLE;
    tick_num2 = (UINT32)LOS_TickCountGet(); /* ȡδʱļֵ */

    printf("Timer_CallBack_Count2=%d\r\n", s_TmrCb_Count2);

    printf("tick_num2=%d\r\n", tick_num2);

}

/*******************************************************************
  * @    BSP_Init
  * @ ˵ 弶ʼаϵĳʼɷ
  * @     
  * @ ֵ   
  ******************************************************************/
static void BSP_Init(void)
{
    ald_cmu_init();
    ald_cmu_pll_config(ALD_CMU_PLL_INPUT_HRC, ALD_CMU_PLL_OUTPUT_72M);
    ald_cmu_clock_config(ALD_CMU_CLOCK_PLL, 72000000);
    ald_cmu_perh_clock_config(ALD_CMU_PERH_ALL, ENABLE);
    SysTick->CTRL  &= ~SysTick_CTRL_ENABLE_Msk;

    bsp_led_init();
    bsp_uart_init();
    bsp_key_init();
}

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
