/**********************************************************************************
 *
 * @file    main.c
 * @brief   ADC_SingleConversion C file
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          2021/09/03      AE              the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */
#include <string.h>
#include "main.h"
/* LiteOS ͷļ */
#include "los_sys.h"
#include "los_task.ph"

/* Private Macros ------------------------------------------------------------ */

#define KEY1_EVENT  (0x01 << 0)/* ¼λ0 */
#define KEY2_EVENT  (0x01 << 1)/* ¼λ1 */

/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */

static UINT32 AppTaskCreate(void);
static UINT32 Creat_LED_Task(void);
static UINT32 Creat_Key_Task(void);

static void LED_Task(void);
static void Key_Task(void);
static void BSP_Init(void);

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */

/*  */
UINT32 g_LED_Task_Handle;
UINT32 g_Key_Task_Handle;

/* ¼־Ŀƿ */
static EVENT_CB_S s_EventGroup_CB;

/* Private Function ---------------------------------------------------------- */

/***************************************************************
  * @brief  
  * @param  
  * @retval 
  * @note   һӲʼ
            ڶAPPӦ
            LiteOSʼȣʧϢ
  **************************************************************/
int main(void)
{
    UINT32 uwRet = LOS_OK;  /* һ񴴽ķֵĬΪɹ */

    /* سʼ */
    BSP_Init();

    printf("example start\r\n");

    /* LiteOS ں˳ʼ */
    uwRet = LOS_KernelInit();

    if (uwRet != LOS_OK)
    {
        printf("[err]LiteOS core init err! code = 0x%X\r\n", uwRet);
        return LOS_NOK;
    }

    uwRet = AppTaskCreate();

    if (uwRet != LOS_OK)
    {
        printf("[err]AppTaskCreate err! cde = 0x%X\r\n", uwRet);
        return LOS_NOK;
    }

    /* LiteOS */
    LOS_Start();

    /* ²ִе */
    while (1);

}


/*********************************************************************
  * @    AppTaskCreate
  * @ ˵ 񴴽Ϊ˷е񴴽Է
  * @      
  * @ ֵ   
  *******************************************************************/
static UINT32 AppTaskCreate(void)
{
    /* һͱʼΪLOS_OK */
    UINT32 uwRet = LOS_OK;

    /* һ¼־*/
    uwRet = LOS_EventInit(&s_EventGroup_CB);

    if (uwRet != LOS_OK)
    {
        printf("s_EventGroup_CB create err! code = 0x%X\r\n", uwRet);
    }

    uwRet = Creat_LED_Task();

    if (uwRet != LOS_OK)
    {
        printf("LED_Task create err! code = 0x%X\r\n", uwRet);
        return uwRet;
    }

    uwRet = Creat_Key_Task();

    if (uwRet != LOS_OK)
    {
        printf("Key_Task create err! code = 0x%X\r\n", uwRet);
        return uwRet;
    }

    return LOS_OK;
}


/******************************************************************
  * @    Creat_LED_Task
  * @ ˵ LED_Task
  * @     
  * @ ֵ   
  ******************************************************************/
static UINT32 Creat_LED_Task()
{
    /* һͱʼΪLOS_OK */
    UINT32 uwRet = LOS_OK;

    /* һڴĲṹ */
    TSK_INIT_PARAM_S task_init_param;

    task_init_param.usTaskPrio = 5; /* ȼֵԽСȼԽ */
    task_init_param.pcName = "LED_Task";/*  */
    task_init_param.pfnTaskEntry = (TSK_ENTRY_FUNC)LED_Task;/*  */
    task_init_param.uwStackSize = 1024;     /* ջС */

    uwRet = LOS_TaskCreate(&g_LED_Task_Handle, &task_init_param);/*  */
    return uwRet;
}
/*******************************************************************
  * @    Creat_Key_Task
  * @ ˵ Key_Task
  * @     
  * @ ֵ   
  ******************************************************************/
static UINT32 Creat_Key_Task()
{
    /* һͱʼΪLOS_OK */
    UINT32 uwRet = LOS_OK;
    TSK_INIT_PARAM_S task_init_param;

    task_init_param.usTaskPrio = 4; /* ȼֵԽСȼԽ */
    task_init_param.pcName = "Key_Task";    /* */
    task_init_param.pfnTaskEntry = (TSK_ENTRY_FUNC)Key_Task;/*  */
    task_init_param.uwStackSize = 1024; /* ջС */

    uwRet = LOS_TaskCreate(&g_Key_Task_Handle, &task_init_param);/*  */

    return uwRet;
}

/******************************************************************
  * @    LED_Task
  * @ ˵ LED_Taskʵ
  * @      NULL
  * @ ֵ   NULL
  *****************************************************************/
static void LED_Task(void)
{
    /* һ¼ձ */
    UINT32 uwRet;

    /* һѭܷ */
    while (1)
    {
        /* ȴ¼־ */
        uwRet = LOS_EventRead(&s_EventGroup_CB,          /* ¼־ */
                              KEY1_EVENT | KEY2_EVENT, /* ȴȤ¼ */
                              LOS_WAITMODE_AND,       /* ȴλλ */
                              LOS_WAIT_FOREVER);          /* ޵ȴ */

        if ((uwRet & (KEY1_EVENT | KEY2_EVENT)) == (KEY1_EVENT | KEY2_EVENT))
        {
            /* ɲȷ */
            printf("KEY1 and KEY2 down\r\n");
            DEBUG_LED1_TOGGLE;              /* LED1 ת */
            DEBUG_LED2_TOGGLE;              /* LED2 ת */
            LOS_EventClear(&s_EventGroup_CB, ~KEY1_EVENT);  /* ¼־ */
            LOS_EventClear(&s_EventGroup_CB, ~KEY2_EVENT);  /* ¼־ */
        }
    }
}

/******************************************************************
  * @    Key_Task
  * @ ˵ Key_Taskʵ
  * @      NULL
  * @ ֵ   NULL
  *****************************************************************/
static void Key_Task(void)
{
    /* һͱʼΪLOS_OK */
    UINT32 uwRet = LOS_OK;
    UINT8  uckey_code = 0;

    /* һѭܷ */
    while (1)
    {
        bsp_key_scan();
        uckey_code = bsp_get_key();
        
        if (uckey_code != KEY_NONE)
        {
            switch (uckey_code)
            {
                case KEY_DOWN_CENTER:
                    printf("KEY2 down\r\n");
                    /* һ¼2 */
                    LOS_EventWrite(&s_EventGroup_CB, KEY2_EVENT);

                    break;

                case KEY_DOWN_TOP:
                    printf("KEY1 down\r\n");
                    /* һ¼1 */
                    LOS_EventWrite(&s_EventGroup_CB, KEY1_EVENT);
                    break;
                default:
                    break;
            }
        }
        LOS_TaskDelay(20);     /* ÿ20msɨһ */
    }
}

/*******************************************************************
  * @    BSP_Init
  * @ ˵ 弶ʼаϵĳʼɷ
  * @     
  * @ ֵ   
  ******************************************************************/
static void BSP_Init(void)
{
    ald_cmu_init();
    ald_cmu_pll_config(ALD_CMU_PLL_INPUT_HRC, ALD_CMU_PLL_OUTPUT_72M);
    ald_cmu_clock_config(ALD_CMU_CLOCK_PLL, 72000000);
    ald_cmu_perh_clock_config(ALD_CMU_PERH_ALL, ENABLE);
    SysTick->CTRL  &= ~SysTick_CTRL_ENABLE_Msk;

    bsp_led_init();
    bsp_uart_init();
    bsp_key_init();
}

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
