/**********************************************************************************
 *
 * @file    main.c
 * @brief   ADC_SingleConversion C file
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          2021/09/03      AE              the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */
#include <string.h>
#include "main.h"
/* LiteOS ͷļ */
#include "los_sys.h"
#include "los_task.ph"
#include "los_sem.h"

/* Private Macros ------------------------------------------------------------ */
/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */

static UINT32 AppTaskCreate(void);
static UINT32 Creat_Pend_Task(void);
static UINT32 Creat_Post_Task(void);

static void Pend_Task(void);
static void Post_Task(void);
static void BSP_Init(void);

/* Private Variables --------------------------------------------------------- */
/* Public Variables ---------------------------------------------------------- */

/*  */
UINT32 g_Pend_Task_Handle;
UINT32 g_Post_Task_Handle;

/* źľ */
UINT32 g_CountSem_Handle;

/* Private Function ---------------------------------------------------------- */

/***************************************************************
  * @brief  
  * @param  
  * @retval 
  * @note   һӲʼ
            ڶAPPӦ
            LiteOSʼȣʧϢ
  **************************************************************/
int main(void)
{
    UINT32 uwRet = LOS_OK;  /* һ񴴽ķֵĬΪɹ */

    /* سʼ */
    BSP_Init();

    printf("example start\r\n");

    /* LiteOS ں˳ʼ */
    uwRet = LOS_KernelInit();

    if (uwRet != LOS_OK)
    {
        printf("[err]LiteOS core init err! code = 0x%X\n", uwRet);
        return LOS_NOK;
    }

    uwRet = AppTaskCreate();

    if (uwRet != LOS_OK)
    {
        printf("[err]AppTaskCreate err! cde = 0x%X\n", uwRet);
        return LOS_NOK;
    }

    /* LiteOS */
    LOS_Start();

    /* ²ִе */
    while (1);

}


/*********************************************************************
  * @    AppTaskCreate
  * @ ˵ 񴴽Ϊ˷е񴴽Է
  * @      
  * @ ֵ   
  *******************************************************************/
static UINT32 AppTaskCreate(void)
{
    /* һͱʼΪLOS_OK */
    UINT32 uwRet = LOS_OK;

    /* һźʼֵΪ5*/
    uwRet = LOS_SemCreate(5, &g_CountSem_Handle);

    if (uwRet != LOS_OK)
    {
        printf("CountSem create err ! code = 0x%X\n", uwRet);
        return uwRet;
    }

    uwRet = Creat_Pend_Task();

    if (uwRet != LOS_OK)
    {
        printf("Pend_Task create err! code = 0x%X\n", uwRet);
        return uwRet;
    }

    uwRet = Creat_Post_Task();

    if (uwRet != LOS_OK)
    {
        printf("Post_Task create err! code = 0x%X\n", uwRet);
        return uwRet;
    }

    return LOS_OK;
}


/******************************************************************
  * @    Creat_Pend_Task
  * @ ˵ Pend_Task
  * @     
  * @ ֵ   
  ******************************************************************/
static UINT32 Creat_Pend_Task()
{
    /* һķͣʼΪɹķֵ */
    UINT32 uwRet = LOS_OK;

    /* һڴĲṹ */
    TSK_INIT_PARAM_S task_init_param;

    task_init_param.usTaskPrio = 5; /* ȼֵԽСȼԽ */
    task_init_param.pcName = "Pend_Task";/*  */
    task_init_param.pfnTaskEntry = (TSK_ENTRY_FUNC)Pend_Task;/*  */
    task_init_param.uwStackSize = 1024;     /* ջС */

    uwRet = LOS_TaskCreate(&g_Pend_Task_Handle, &task_init_param);/*  */
    return uwRet;
}
/*******************************************************************
  * @    Creat_Post_Task
  * @ ˵ Post_Task
  * @     
  * @ ֵ   
  ******************************************************************/
static UINT32 Creat_Post_Task()
{
    /* һķͣʼΪɹķֵ */
    UINT32 uwRet = LOS_OK;
    TSK_INIT_PARAM_S task_init_param;

    task_init_param.usTaskPrio = 4; /* ȼֵԽСȼԽ */
    task_init_param.pcName = "Post_Task";   /* */
    task_init_param.pfnTaskEntry = (TSK_ENTRY_FUNC)Post_Task;/*  */
    task_init_param.uwStackSize = 1024; /* ջС */

    uwRet = LOS_TaskCreate(&g_Post_Task_Handle, &task_init_param);/*  */

    return uwRet;
}

/******************************************************************
  * @    Pend_Task
  * @ ˵ Pend_Taskʵ
  * @      NULL
  * @ ֵ   NULL
  *****************************************************************/
static void Pend_Task(void)
{
    UINT32 uwRet = LOS_OK;
    UINT8  uckey_code = 0;

    /* һѭܷ */
    while (1)
    {
        bsp_key_scan();
        uckey_code = bsp_get_key();
        
        if (uckey_code != KEY_NONE)
        {
            switch (uckey_code)
            {
                case KEY_DOWN_CENTER:

                    break;

                case KEY_DOWN_TOP:
                    /* ȡһźȴʱ0 */
                    uwRet = LOS_SemPend(g_CountSem_Handle, 0);
                    DEBUG_LED1_TOGGLE

                    if (LOS_OK ==  uwRet)
                        printf("\r\nKEY1 down , get 1\r\n");
                    else
                        printf("\r\nKEY1 down , get 0 (empty)\r\n");

                    break;
                default:
                    break;
            }
        }
        LOS_TaskDelay(10);     /* ÿ10msɨһ */
    }
}
/******************************************************************
  * @    Post_Task
  * @ ˵ Post_Taskʵ
  * @      NULL
  * @ ֵ   NULL
  *****************************************************************/
static void Post_Task(void)
{
    UINT32 uwRet = LOS_OK;
    UINT8  uckey_code = 0;

    while (1)
    {
        bsp_key_scan();
        uckey_code = bsp_get_key();
        
        if (uckey_code != KEY_NONE)
        {
            switch (uckey_code)
            {
                case KEY_DOWN_CENTER:
                    /* ͷһźLiteOSļźһֱͷţڱעһ¼*/
                    uwRet = LOS_SemPost(g_CountSem_Handle);
                    DEBUG_LED2_TOGGLE

                    if (LOS_OK == uwRet)
                        printf("\r\nKEY2 down , release 1\r\n");
                    else
                        printf("\r\n[err]KEY2 down , release err\r\n");

                    break;

                case KEY_DOWN_TOP:

                    break;
                default:
                    break;
            }
        }
        LOS_TaskDelay(20);     /* ÿ20msɨһ */
    }
}


/*******************************************************************
  * @    BSP_Init
  * @ ˵ 弶ʼаϵĳʼɷ
  * @     
  * @ ֵ   
  ******************************************************************/
static void BSP_Init(void)
{
    ald_cmu_init();
    ald_cmu_pll_config(ALD_CMU_PLL_INPUT_HRC, ALD_CMU_PLL_OUTPUT_72M);
    ald_cmu_clock_config(ALD_CMU_CLOCK_PLL, 72000000);
    ald_cmu_perh_clock_config(ALD_CMU_PERH_ALL, ENABLE);
    SysTick->CTRL  &= ~SysTick_CTRL_ENABLE_Msk;

    bsp_led_init();
    bsp_uart_init();
    bsp_key_init();
}

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
