/**********************************************************************************
 *
 * @file    main.c
 * @brief   ADC_SingleConversion C file
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          2021/09/03      AE              the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may 
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */
#include <string.h>
#include "main.h"
/* LiteOS ͷļ */
#include "los_sys.h"
#include "los_task.ph"
#include "los_sem.h"

/* Private Macros ------------------------------------------------------------ */
/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */

static UINT32 AppTaskCreate(void);
static UINT32 Creat_Read_Task(void);
static UINT32 Creat_Write_Task(void);

static void Read_Task(void);
static void Write_Task(void);
static void BSP_Init(void);

/* Private Variables --------------------------------------------------------- */
/* Public Variables ---------------------------------------------------------- */

/*  */
UINT32 g_Read_Task_Handle;
UINT32 g_Write_Task_Handle;

/* ֵźľ */
UINT32 g_BinarySem_Handle;

uint8_t g_ucValue[2] = { 0x00U, 0x00U };

/* Private Function ---------------------------------------------------------- */

/***************************************************************
  * @brief  
  * @param  
  * @retval 
  * @note   һӲʼ
            ڶAPPӦ
            LiteOSʼȣʧϢ
  **************************************************************/
int main(void)
{
    UINT32 uwRet = LOS_OK;  /* һ񴴽ķֵĬΪɹ */

    /* سʼ */
    BSP_Init();

    printf("example start\r\n");

    /* LiteOS ں˳ʼ */
    uwRet = LOS_KernelInit();

    if (uwRet != LOS_OK)
    {
        printf("[err]LiteOS core init err! code = 0x%X\r\n", uwRet);
        return LOS_NOK;
    }

    uwRet = AppTaskCreate();

    if (uwRet != LOS_OK)
    {
        printf("[err]AppTaskCreate err! cde = 0x%X\r\n", uwRet);
        return LOS_NOK;
    }

    /* LiteOS */
    LOS_Start();

    /* ²ִе */
    while (1);

}


/*********************************************************************
  * @    AppTaskCreate
  * @ ˵ 񴴽Ϊ˷е񴴽Է
  * @      
  * @ ֵ   
  *******************************************************************/
static UINT32 AppTaskCreate(void)
{
    /* һͱʼΪLOS_OK */
    UINT32 uwRet = LOS_OK;

    /* һֵź*/
    uwRet = LOS_BinarySemCreate(1, &g_BinarySem_Handle);

    if (uwRet != LOS_OK)
    {
        printf("BinarySem create err ! code = 0x%X\r\n", uwRet);
        return uwRet;
    }

    uwRet = Creat_Read_Task();

    if (uwRet != LOS_OK)
    {
        printf("Read_Task create err! code = 0x%X\r\n", uwRet);
        return uwRet;
    }

    uwRet = Creat_Write_Task();

    if (uwRet != LOS_OK)
    {
        printf("Write_Task create err! code = 0x%X\r\n", uwRet);
        return uwRet;
    }

    return LOS_OK;
}


/******************************************************************
  * @    Creat_Read_Task
  * @ ˵ Read_Task
  * @     
  * @ ֵ   
  ******************************************************************/
static UINT32 Creat_Read_Task()
{
    /* һͱʼΪLOS_OK */
    UINT32 uwRet = LOS_OK;

    /* һڴĲṹ */
    TSK_INIT_PARAM_S task_init_param;

    task_init_param.usTaskPrio = 5; /* ȼֵԽСȼԽ */
    task_init_param.pcName = "Read_Task";/*  */
    task_init_param.pfnTaskEntry = (TSK_ENTRY_FUNC)Read_Task;/*  */
    task_init_param.uwStackSize = 1024;     /* ջС */

    uwRet = LOS_TaskCreate(&g_Read_Task_Handle, &task_init_param);/*  */
    return uwRet;
}
/*******************************************************************
  * @    Creat_Write_Task
  * @ ˵ Write_Task
  * @     
  * @ ֵ   
  ******************************************************************/
static UINT32 Creat_Write_Task()
{
    /* һͱʼΪLOS_OK */
    UINT32 uwRet = LOS_OK;
    TSK_INIT_PARAM_S task_init_param;

    task_init_param.usTaskPrio = 4; /* ȼֵԽСȼԽ */
    task_init_param.pcName = "Write_Task";  /* */
    task_init_param.pfnTaskEntry = (TSK_ENTRY_FUNC)Write_Task;/*  */
    task_init_param.uwStackSize = 1024; /* ջС */

    uwRet = LOS_TaskCreate(&g_Write_Task_Handle, &task_init_param);/*  */

    return uwRet;
}

/******************************************************************
  * @    Read_Task
  * @ ˵ Read_Taskʵ
  * @      NULL
  * @ ֵ   NULL
  *****************************************************************/
static void Read_Task(void)
{
    /* һѭܷ */
    while (1)
    {
        LOS_SemPend(g_BinarySem_Handle, LOS_WAIT_FOREVER);    /* ȡֵź xSemaphore,ûȡһֱȴ */

        if (g_ucValue [ 0 ] == g_ucValue [ 1 ])
        {
            printf("\r\nSuccessful\r\n");
        }
        else
        {
            printf("\r\nFail\r\n");
        }

        LOS_SemPost(g_BinarySem_Handle);     /* ֵź xSemaphore */

    }
}
/******************************************************************
  * @    Write_Task
  * @ ˵ Write_Taskʵ
  * @      NULL
  * @ ֵ   NULL
  *****************************************************************/
static void Write_Task(void)
{
    /* һķͣʼΪɹķֵ */
    UINT32 uwRet = LOS_OK;

    /* һѭܷ */
    while (1)
    {
        LOS_SemPend(g_BinarySem_Handle, LOS_WAIT_FOREVER);     /* ȡֵź g_BinarySem_Handleûȡһֱȴ */
        g_ucValue [ 0 ] ++;
        DEBUG_LED1_TOGGLE
        LOS_TaskDelay(1000);                     /* ʱ1000ms */
        g_ucValue [ 1 ] ++;
        DEBUG_LED2_TOGGLE
        LOS_SemPost(g_BinarySem_Handle);      /* ֵź xSemaphore */
        LOS_TaskYield();                                    /* ʣʱƬһл */
    }
}

/*******************************************************************
  * @    BSP_Init
  * @ ˵ 弶ʼаϵĳʼɷ
  * @     
  * @ ֵ   
  ******************************************************************/
static void BSP_Init(void)
{
    /*ʼʱ*/
    ald_cmu_init();
    ald_cmu_pll_config(ALD_CMU_PLL_INPUT_HRC, ALD_CMU_PLL_OUTPUT_72M);
    ald_cmu_clock_config(ALD_CMU_CLOCK_PLL, 72000000);
    ald_cmu_perh_clock_config(ALD_CMU_PERH_ALL, ENABLE);
    SysTick->CTRL  &= ~SysTick_CTRL_ENABLE_Msk;

    bsp_led_init();
    bsp_uart_init();
    bsp_key_init();
}

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
