/**********************************************************************************
 *
 * @file    main.c
 * @brief   ADC_SingleConversion C file
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          2021/09/03      AE              the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */

#include <string.h>
#include "main.h"
/* LiteOS ͷļ */
#include "los_sys.h"
#include "los_task.ph"
#include "los_queue.h"

/* Private Macros ------------------------------------------------------------ */

/* Ϣг */
#define  TEST_QUEUE_LEN   10
#define  TEST_QUEUE_SIZE  10

/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */

static UINT32 AppTaskCreate(void);
static UINT32 Creat_Receive_Task(void);
static UINT32 Creat_Send_Task(void);

static void Receive_Task(void);
static void Send_Task(void);
static void BSP_Init(void);

/* Private Variables --------------------------------------------------------- */
/* Public Variables ---------------------------------------------------------- */

/*  */
UINT32 g_Receive_Task_Handle;
UINT32 g_Send_Task_Handle;

/* Ϣеľ */
UINT32 g_Test_Queue_Handle;

/* Private Function ---------------------------------------------------------- */

/***************************************************************
  * @brief  
  * @param  
  * @retval 
  * @note   һӲʼ
            ڶAPPӦ
            LiteOSʼȣʧϢ
  **************************************************************/
int main(void)
{
    UINT32 uwRet = LOS_OK;  /* һ񴴽ķֵĬΪɹ */

    /* سʼ */
    BSP_Init();

    printf("example start\r\n");

    /* LiteOS ں˳ʼ */
    uwRet = LOS_KernelInit();

    if (uwRet != LOS_OK)
    {
        printf("[err]LiteOS core init err! code = 0x%X\n", uwRet);
        return LOS_NOK;
    }

    uwRet = AppTaskCreate();

    if (uwRet != LOS_OK)
    {
        printf("[err]AppTaskCreate err! cde = 0x%X\n", uwRet);
        return LOS_NOK;
    }

    /* LiteOS */
    LOS_Start();

    /* ²ִе */
    while (1);

}

/*********************************************************************
  * @    AppTaskCreate
  * @ ˵ 񴴽Ϊ˷е񴴽Է
  * @      
  * @ ֵ   
  *******************************************************************/
static UINT32 AppTaskCreate(void)
{
    /* һͱʼΪLOS_OK */
    UINT32 uwRet = LOS_OK;

    /* һԶ*/
    uwRet = LOS_QueueCreate("Test_Queue",               /* е */
                            TEST_QUEUE_LEN,         /* еĳ */
                            &g_Test_Queue_Handle,   /* еID() */
                            0,                      /* ģʽٷʱδʹ */
                            TEST_QUEUE_SIZE);   /* ڵСλΪֽ */

    if (uwRet != LOS_OK)
    {
        printf("Test_Queue create err ! code = 0x%X\n", uwRet);
        return uwRet;
    }

    uwRet = Creat_Receive_Task();

    if (uwRet != LOS_OK)
    {
        printf("Receive_Task create err! code = 0x%X\n", uwRet);
        return uwRet;
    }

    uwRet = Creat_Send_Task();

    if (uwRet != LOS_OK)
    {
        printf("Send_Task create err! code = 0x%X\n", uwRet);
        return uwRet;
    }

    return LOS_OK;
}

/******************************************************************
  * @    Creat_Receive_Task
  * @ ˵ Receive_Task
  * @     
  * @ ֵ   
  ******************************************************************/
static UINT32 Creat_Receive_Task()
{
    /* һͱʼΪLOS_OK */
    UINT32 uwRet = LOS_OK;

    /* һڴĲṹ */
    TSK_INIT_PARAM_S task_init_param;

    task_init_param.usTaskPrio = 5; /* ȼֵԽСȼԽ */
    task_init_param.pcName = "Receive_Task";/*  */
    task_init_param.pfnTaskEntry = (TSK_ENTRY_FUNC)Receive_Task;/*  */
    task_init_param.uwStackSize = 1024;     /* ջС */

    uwRet = LOS_TaskCreate(&g_Receive_Task_Handle, &task_init_param);/*  */
    return uwRet;
}

/*******************************************************************
  * @    Creat_Send_Task
  * @ ˵ Send_Task
  * @     
  * @ ֵ   
  ******************************************************************/
static UINT32 Creat_Send_Task()
{
    /* һͱʼΪLOS_OK */
    UINT32 uwRet = LOS_OK;
    TSK_INIT_PARAM_S task_init_param;

    task_init_param.usTaskPrio = 4; /* ȼֵԽСȼԽ */
    task_init_param.pcName = "Send_Task";   /* */
    task_init_param.pfnTaskEntry = (TSK_ENTRY_FUNC)Send_Task;/*  */
    task_init_param.uwStackSize = 1024; /* ջС */

    uwRet = LOS_TaskCreate(&g_Send_Task_Handle, &task_init_param);/*  */

    return uwRet;
}

/******************************************************************
  * @    Receive_Task
  * @ ˵ Receive_Taskʵ
  * @      NULL
  * @ ֵ   NULL
  *****************************************************************/
static void Receive_Task(void)
{
    /* һͱʼΪLOS_OK */
    UINT32 uwRet = LOS_OK;
    UINT32 *r_queue;

    /* һѭܷ */
    while (1)
    {
        DEBUG_LED1_TOGGLE
        DEBUG_LED2_TOGGLE

        /* жȡգȴʱΪһֱȴ */
        uwRet = LOS_QueueRead(g_Test_Queue_Handle,  /* ȡգеID() */
                              &r_queue,           /* ȡգݱλ */
                              TEST_QUEUE_SIZE,        /* ȡգݵĳ */
                              LOS_WAIT_FOREVER);  /* ȴʱ䣺һֱ */

        if (LOS_OK == uwRet)
        {
            printf("recv msg = %x\r\n", *r_queue);
        }
        else
        {
            printf("[err] msg recv err! code = 0x%X\n", uwRet);
        }
    }
}


/******************************************************************
  * @    Send_Task
  * @ ˵ Send_Taskʵ
  * @      NULL
  * @ ֵ   NULL
  *****************************************************************/
static void Send_Task(void)
{
    /* һͱʼΪLOS_OK */
    UINT32 uwRet = LOS_OK;
    UINT8  uckey_code = 0;

    /* Ҫ͵Ϣ */
    UINT32 send_data1 = 1;
    UINT32 send_data2 = 2;

    /* һѭܷ */
    while (1)
    {
        bsp_key_scan();
        uckey_code = bsp_get_key();
        
        if (uckey_code != KEY_NONE)
        {
            switch (uckey_code)
            {
                case KEY_DOWN_CENTER:
                    /* д루ͣУȴʱΪ 0  */
                    uwRet = LOS_QueueWrite(g_Test_Queue_Handle,  /* д루ͣеID() */
                                           &send_data1,                /* д루ͣ */
                                           sizeof(send_data1), /* ݵĳ */
                                           0);                                 /* ȴʱΪ 0  */

                    if (LOS_OK != uwRet)
                    {
                        printf("msg send err! code = 0x%X\r\n", uwRet);
                    }

                    break;

                case KEY_DOWN_TOP:
                   /* д루ͣУȴʱΪ 0  */
                    uwRet = LOS_QueueWrite(g_Test_Queue_Handle,  /* д루ͣеID() */
                                           &send_data2,                /* д루ͣ */
                                           sizeof(send_data2), /* ݵĳ */
                                           0);                                 /* ȴʱΪ 0  */

                    if (LOS_OK != uwRet)
                    {
                        printf("msg send err! code = 0x%X\r\n", uwRet);
                    }
                    break;
                default:
                    break;
            }
        }
        /* 20msɨһ */
        LOS_TaskDelay(20);
    }
}

/*******************************************************************
  * @    BSP_Init
  * @ ˵ 弶ʼаϵĳʼɷ
  * @     
  * @ ֵ   
  ******************************************************************/
static void BSP_Init(void)
{
    /*ʼʱ*/
    ald_cmu_init();
    ald_cmu_pll_config(ALD_CMU_PLL_INPUT_HRC, ALD_CMU_PLL_OUTPUT_72M);
    ald_cmu_clock_config(ALD_CMU_CLOCK_PLL, 72000000);
    ald_cmu_perh_clock_config(ALD_CMU_PERH_ALL, ENABLE);
    SysTick->CTRL  &= ~SysTick_CTRL_ENABLE_Msk;

    bsp_led_init();
    bsp_uart_init();
    bsp_key_init();
}

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
