/**********************************************************************************
 *
 * @file    main.c
 * @brief   ADC_SingleConversion C file
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          2021/09/03      AE              the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */
#include <string.h>
#include "main.h"
/* LiteOS ͷļ */
#include "los_sys.h"
#include "los_task.ph"

/* Private Macros ------------------------------------------------------------ */
/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */

static UINT32 AppTaskCreate(void);
static UINT32 Creat_Test1_Task(void);
static UINT32 Creat_Test2_Task(void);
static void Test1_Task(void);
static void Test2_Task(void);
static void BSP_Init(void);

/* Private Variables --------------------------------------------------------- */
/* Public Variables ---------------------------------------------------------- */

/*  */
UINT32 g_Test1_Task_Handle;
UINT32 g_Test2_Task_Handle;

/* Private Function ---------------------------------------------------------- */

/***************************************************************
  * @brief  
  * @param  
  * @retval 
  * @note   һӲʼ
            ڶAPPӦ
            LiteOSʼȣʧϢ
  **************************************************************/
int main(void)
{
    UINT32 uwRet = LOS_OK;  /* һ񴴽ķֵĬΪɹ */

    /* سʼ */
    BSP_Init();

    printf("example start\r\n");

    /* LiteOS ں˳ʼ */
    uwRet = LOS_KernelInit();

    if (uwRet != LOS_OK)
    {
        printf("[err]LiteOS core init err! code = 0x%X\n", uwRet);
        return LOS_NOK;
    }

    uwRet = AppTaskCreate();

    if (uwRet != LOS_OK)
    {
        printf("[err]AppTaskCreate err! cde = 0x%X\n", uwRet);
        return LOS_NOK;
    }

    /* LiteOS */
    LOS_Start();

    /* ²ִе */
    while (1);
}


/***********************************************************************
  * @    AppTaskCreate
  * @ ˵ 񴴽Ϊ˷е񴴽Է
  * @      
  * @ ֵ   
  *****************************************************************/
static UINT32 AppTaskCreate(void)
{
    /* һͱʼΪLOS_OK */
    UINT32 uwRet = LOS_OK;

    uwRet = Creat_Test1_Task();

    if (uwRet != LOS_OK)
    {
        printf("[err]Test1_Task create err! code = 0x%X\n", uwRet);
        return uwRet;
    }

    uwRet = Creat_Test2_Task();

    if (uwRet != LOS_OK)
    {
        printf("[err]Test2_Task create err! code = 0x%X\n", uwRet);
        return uwRet;
    }

    return LOS_OK;
}


/******************************************************************
  * @    Creat_Test1_Task
  * @ ˵ Test1_Task
  * @     
  * @ ֵ   
  ******************************************************************/
static UINT32 Creat_Test1_Task()
{
    /* һķͣʼΪɹķֵ */
    UINT32 uwRet = LOS_OK;

    /* һڴĲṹ */
    TSK_INIT_PARAM_S task_init_param;

    task_init_param.usTaskPrio = 3; /* ȼֵԽСȼԽ */
    task_init_param.pcName = "Test1_Task";/*  */
    task_init_param.pfnTaskEntry = (TSK_ENTRY_FUNC)Test1_Task;/*  */
    task_init_param.uwStackSize = 1024;     /* ջС */

    uwRet = LOS_TaskCreate(&g_Test1_Task_Handle, &task_init_param);/*  */
    return uwRet;
}
/*******************************************************************
  * @    Creat_Test2_Task
  * @ ˵ Test2_Task
  * @     
  * @ ֵ   
  ******************************************************************/
static UINT32 Creat_Test2_Task()
{
    /* һķͣʼΪɹķֵ */
    UINT32 uwRet = LOS_OK;
    TSK_INIT_PARAM_S task_init_param;

    task_init_param.usTaskPrio = 4; /* ȼֵԽСȼԽ */
    task_init_param.pcName = "Test2_Task";  /* */
    task_init_param.pfnTaskEntry = (TSK_ENTRY_FUNC)Test2_Task;/*  */
    task_init_param.uwStackSize = 1024; /* ջС */

    uwRet = LOS_TaskCreate(&g_Test2_Task_Handle, &task_init_param);/*  */

    return uwRet;
}


/******************************************************************
  * @    Test1_Task
  * @ ˵ Test1_Taskʵ
  * @      NULL
  * @ ֵ   NULL
  *****************************************************************/
static void Test1_Task(void)
{
    /* һѭܷ */
    while (1)
    {
        DEBUG_LED2_TOGGLE
        printf("task1 runing\r\n");
        LOS_TaskDelay(1000);
    }
}
/******************************************************************
  * @    Test2_Task
  * @ ˵ Test2_Taskʵ
  * @      NULL
  * @ ֵ   NULL
  *****************************************************************/
static void Test2_Task(void)
{
    /* һѭܷ */
    while (1)
    {
        DEBUG_LED1_TOGGLE
        printf("task2 runing\r\n");
        LOS_TaskDelay(500);
    }
}

/*******************************************************************
  * @    BSP_Init
  * @ ˵ 弶ʼаϵĳʼɷ
  * @     
  * @ ֵ   
  ******************************************************************/
static void BSP_Init(void)
{
    /*ʼʱ*/
    ald_cmu_init();
    ald_cmu_pll_config(ALD_CMU_PLL_INPUT_HRC, ALD_CMU_PLL_OUTPUT_72M);
    ald_cmu_clock_config(ALD_CMU_CLOCK_PLL, 72000000);
    ald_cmu_perh_clock_config(ALD_CMU_PERH_ALL, ENABLE);
    SysTick->CTRL  &= ~SysTick_CTRL_ENABLE_Msk;

    bsp_led_init();
    bsp_uart_init();
    bsp_key_init();
}

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
