/**
  *********************************************************************************
  *
  * @file    bsp_key.c
  * @brief   KEY driver
  *
  * @version V1.0
  * @date    24 Apr 2020
  * @author  AE Team
  * @note
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  *********************************************************************************
  */

#ifndef __BSP_KEY_H__
#define __BSP_KEY_H__

#ifdef _cplusplus
extern "C" {
#endif

    /** @addtogroup ES32F3xxx_BSP
      * @{
      */

    /** @addtogroup KEY
      * @{
      */

    /** @defgroup KEY_Private_Macros key Private Macros
      * @{
      */

#define KEY_COUNT    5

    /* Rename key state name according to application */
#define KEY_DOWN_TOP        KEY_TOP_DOWN
#define KEY_UP_TOP      KEY_TOP_UP
#define KEY_LONG_TOP        KEY_TOP_LONG

#define KEY_DOWN_BOTTOM     KEY_BOTTOM_DOWN
#define KEY_UP_BOTTOM       KEY_BOTTOM_UP
#define KEY_LONG_BOTTOM     KEY_BOTTOM_LONG

#define KEY_DOWN_LEFT       KEY_LEFT_DOWN
#define KEY_UP_LEFT         KEY_LEFT_UP
#define KEY_LONG_LEFT       KEY_LEFT_LONG

#define KEY_DOWN_RIGHT      KEY_RIGHT_DOWN
#define KEY_UP_RIGHT        KEY_RIGHT_UP
#define KEY_LONG_RIGHT      KEY_RIGHT_LONG

#define KEY_DOWN_CENTER     KEY_CENTER_DOWN
#define KEY_UP_CENTER       KEY_CENTER_UP
#define KEY_LONG_CENTER     KEY_CENTER_LONG

    /* Key ID, the parameter of bsp_key_state() function */
    typedef enum
    {
        KID_TOP = 0,
        KID_BOTTOM,
        KID_LEFT,
        KID_RIGHT,
        KID_CENTER
    } key_id_e;

    /* Key detect time and long time detecte time */
#define KEY_FILTER_TIME   5
#define KEY_LONG_TIME     100
#define KEY_FIFO_SIZE   10

    /* Every key gloable variable */
    typedef struct
    {
        uint8_t (*key_pressed_detect)(void); /* Key pressed down read function */
        uint8_t  count;              /* Filter counter */
        uint16_t long_count;             /* Long pressed counter */
        uint16_t long_time;          /* Long pressed time */
        uint8_t  state;              /* Key state */
        uint8_t  repeat_speed;               /* Press continous period */
        uint8_t  repeat_count;
    } key_property_t;

    typedef enum
    {
        KEY_NONE = 0,
        KEY_TOP_DOWN,
        KEY_TOP_UP,
        KEY_TOP_LONG,
        KEY_BOTTOM_DOWN,
        KEY_BOTTOM_UP,
        KEY_BOTTOM_LONG,
        KEY_LEFT_DOWN,
        KEY_LEFT_UP,
        KEY_LEFT_LONG,
        KEY_RIGHT_DOWN,
        KEY_RIGHT_UP,
        KEY_RIGHT_LONG,
        KEY_CENTER_DOWN,
        KEY_CENTER_UP,
        KEY_CENTER_LONG,
    } KEY_ENUM;

    typedef struct
    {
        uint8_t buffer[KEY_FIFO_SIZE];
        uint8_t read;
        uint8_t write;
        uint8_t read2;
    } key_fifo_t;

    /**
      * @}
      */

    /** @addtogroup KEY_Public_Functions
      * @{
      */
    void bsp_key_init(void);
    void bsp_key_scan(void);
    void bsp_put_key(uint8_t keycode);
    uint8_t bsp_get_key(void);
    uint8_t bsp_get_key2(void);
    uint8_t bsp_get_key_state(key_id_e keyid);
    void bsp_set_key_param(uint8_t keyid, uint16_t longtime, uint8_t  repeatspeed);
    void bsp_clear_key(void);

    /**
      * @}
      */

    /**
      * @}
      */

    /**
      * @}
      */

#ifdef _cplusplus
}
#endif

#endif

