/**
  *********************************************************************************
  *
  * @file    bsp_led.c
  * @brief   LED driver
  *
  * @version V1.0
  * @date    24 Apr 2020
  * @author  AE Team
  * @note
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  *********************************************************************************
  */
#include <stdio.h>
#include "bsp_led.h"

/** @addtogroup ES32F3xxx_BSP
  * @{
  */

/** @defgroup LED led
  * @{
  */

/** @defgroup LED_Public_Functions led Public Functions
  * @brief    BSP LED Functions
  * @{
  */

/**
  * @brief  led pin initiation
  * @retval None
  */
void bsp_led_init(void)
{
    ald_gpio_init_t x;

    bsp_led_off(2);
    bsp_led_off(3);
    x.mode  = ALD_GPIO_MODE_OUTPUT;
    x.pupd  = ALD_GPIO_PUSH_UP;
    x.odos  = ALD_GPIO_PUSH_PULL;
    x.nodrv = ALD_GPIO_OUT_DRIVE_1;
    x.podrv = ALD_GPIO_OUT_DRIVE_1;
    x.flt   = ALD_GPIO_FILTER_DISABLE;
    x.type  = ALD_GPIO_TYPE_CMOS;
    x.func  = ALD_GPIO_FUNC_1;
    ald_gpio_init(GPIO_PORT_LED1, GPIO_PIN_LED1, &x);
    ald_gpio_init(GPIO_PORT_LED2, GPIO_PIN_LED2, &x);
}

/**
  * @brief  Led on
  * @param  num: number of the led
  * @retval None
  */
void bsp_led_on(uint8_t num)
{
    if (num == 1)
    {
        GPIO_PORT_LED1->BSRR = (GPIO_PIN_LED1 << 15);
    }
    else if (num == 2)
    {
        GPIO_PORT_LED2->BSRR = (GPIO_PIN_LED2 << 15);
    }
}

/**
  * @brief  Led off
  * @param  num: number of the led
  * @retval None
  */
void bsp_led_off(uint8_t num)
{
    if (num == 1)
    {
        GPIO_PORT_LED1->BSRR = GPIO_PIN_LED1;
    }
    else if (num == 2)
    {
        GPIO_PORT_LED2->BSRR = GPIO_PIN_LED2;
    }
}

/**
  * @brief  Led toggle
  * @param  num: number of the led
  * @retval None
  */
void bsp_led_toggle(uint8_t num)
{
    if (num == 1)
    {
        GPIO_PORT_LED1->BIR = GPIO_PIN_LED1;
    }
    else if (num == 2)
    {
        GPIO_PORT_LED2->BIR = GPIO_PIN_LED2;
    }
}

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */
