/**
  *********************************************************************************
  *
  * @file    bsp_key.c
  * @brief   KEY driver
  *
  * @version V1.0
  * @date    24 Apr 2020
  * @author  AE Team
  * @note
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  *********************************************************************************
  */
#include "ald_conf.h"
#include "bsp_time_base.h"

/** @addtogroup ES32F3xxx_BSP
  * @{
  */

/** @defgroup TIME_BASE time base
  * @{
  */

/** @defgroup Time_base_Public_Functions Time base Public Functions
  * @{
  */



static timer_handle_t h_tim;


static void ald_timer_period_elapsed_callback(struct timer_handle_s *arg)
{
    ald_inc_tick();
}



/**
  * @brief Init bs16t hardware.
  * @retval None
  */
void bsp_time_base_init(void)
{
    /* Initialize BS16T0 */
    h_tim.perh = BS16T0;
    h_tim.init.prescaler    = 0;
    h_tim.init.mode         = TIMER_CNT_MODE_UP;
    h_tim.init.period       = 999;
    h_tim.init.clk_div      = TIMER_CLOCK_DIV1;
    h_tim.init.re_cnt       = 0;
    h_tim.period_elapse_cbk = ald_timer_period_elapsed_callback;
    ald_timer_base_init(&h_tim);
    /* Enable BS16T0 interrupt */
    ald_mcu_irq_config(BS16T0_IRQn, 0, 3, ENABLE);
    /* Enable UPDATE interrupt */
    ald_timer_interrupt_config(&h_tim, TIMER_IT_UPDATE, ENABLE);
    /* Start input pwm from GP16C4T0 channel 1 */
    ald_timer_base_start(&h_tim);
}

/**
  * @brief  BS16T0 handler
  * @retval None
  */
void BS16T0_Handler(void)
{
    ald_timer_irq_handler(&h_tim);
}

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */

