/**********************************************************************************
 *
 * @file    main.h
 * @brief   Header file for DEMO
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          22 Feb  2023    shicc           version:1.0.1
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef   __MAIN_H__
#define   __MAIN_H__

/* Includes ------------------------------------------------------------------ */

#include "md_conf.h"
#include "exec_proc.h"
#include "comm_proc.h"

/* Exported Constants -------------------------------------------------------- */


/* Exported Functions -------------------------------------------------------- */


/* Exported Variables -------------------------------------------------------- */


/* Exported Types ------------------------------------------------------------ */


/* Exported Macros ----------------------------------------------------------- */
#define __USE_CRC32
#define APP_ADDR    0x00010000
#define BOOT_ADDR   0x00000000
#define GO_APP      0x00010000//0xFFFFFFFE
#define GO_BOOT     0x00000000//0xFFFFFFFD

#ifdef  __USE_CRC32
    #define CRC_CAL_ADDR    0x0001DC00
#endif

#define MD_BOOT_FROM_BOOT_ROM()                 \
    do {                                \
        SYSCFG_UNLOCK();                    \
        SET_BIT(SYSCFG->MEMRMP, SYSCFG_MEMRMP_BRMPEN_MSK); \
        CLEAR_BIT(SYSCFG->MEMRMP, SYSCFG_MEMRMP_BFRMPEN_MSK);   \
        SYSCFG_LOCK();                      \
    } while (0)

#define MD_BOOT_FROM_BOOT_FLASH()                   \
    do {                                \
        SYSCFG_UNLOCK();                    \
        CLEAR_BIT(SYSCFG->MEMRMP, SYSCFG_MEMRMP_BRMPEN_MSK);   \
        SET_BIT(SYSCFG->MEMRMP, SYSCFG_MEMRMP_BFRMPEN_MSK); \
        SYSCFG_LOCK();                      \
    } while (0)

#define MD_BOOT_FROM_FLASH()                    \
    do {                                \
        SYSCFG_UNLOCK();                    \
        CLEAR_BIT(SYSCFG->MEMRMP, SYSCFG_MEMRMP_BRMPEN_MSK);   \
        CLEAR_BIT(SYSCFG->MEMRMP, SYSCFG_MEMRMP_BFRMPEN_MSK);   \
        SYSCFG_LOCK();                      \
    } while (0)

/* Exported Variables -------------------------------------------------------- */
/* Exported Constants -------------------------------------------------------- */
/* Exported Functions -------------------------------------------------------- */
#endif /*__MAIN_H__*/

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
