/**
  ********************************************************************************
  *
  * @file    boot_flash.h
  * @brief   Head file of boot flash module.
  *
  * @version V1.0
  * @date    31 Dec 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          31 Dec 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */
#ifndef __BOOT_Flash_H__
#define __BOOT_Flash_H__

#ifdef __cplusplus
extern "C" {
#endif

#include "ald_iap.h"
#include "boot.h"


/** @addtogroup Bootloader
  * @{
  */

/** @addtogroup Flash
  * @{
  */

/** @addtogroup Frame_Public_Macros Public Macros
  * @brief      Flash Public Macros
  * @{
  */

/* boot program stored at the end of the FLASH 32K */
#define BOOT_FLASH_S         0x78000
#define BOOT_FLASH_E         0x7FFFF
/* app flash */
#define APP_FLASH_S          0x00000
#define APP_FLASH_E          0x77FFF
#define APP_FLASH_SIZE       (APP_FLASH_E - APP_FLASH_S + 1)
/* app flash last 8 byte as app validation data */
#define APP_FLASH_INFO_S     0x77FF8
#define APP_FLASH_INFO_E     0x77FFF
#define APP_FLASH_INFO_SIZE  (APP_FLASH_INFO_E - APP_FLASH_INFO_S + 1)

#define APP_FLASH_PAGE_SIZE        0x200
#define APP_XMODEM_FRAME_DATA_SIZE 0X400

#define APP_RUN_RAM_S        0x20004000
#define APP_RUN_RAM_E        0x2000C000
#define OFFSET_VTOR_RAM      0x20004000
#define OFFSET_VTOR_FLASH    APP_FLASH_S
#define APP_LAST_PAGE        (APP_FLASH_SIZE/APP_FLASH_PAGE_SIZE)

/* CRC&APP_LEN address in flash */
#define ADDR_CHECK_APP_FLASH_CRC_LEN    (APP_FLASH_INFO_S + 4)
#define ADDR_CHECK_APP_FLASH_CRC_START  (APP_FLASH_S)

#define USR_FLASH_ADDER(x)  ((x) * APP_XMODEM_FRAME_DATA_SIZE + APP_FLASH_S)
#define INFO_ADDR_IN_PAGE (APP_FLASH_INFO_S & (APP_XMODEM_FRAME_DATA_SIZE - 1))
#define VALID_APP_ADDR(a) ((((a) > APP_FLASH_S) && ((a) <= APP_FLASH_E)) || ((a) == 0)) 


/**
  * @}
  */

/** @addtogroup Flash_Public_Functions
  * @{
  */
extern uint32_t flash_usr_page_get(void);
extern int flash_usr_page_erase(void);
extern int write_data_to_flash(uint8_t page, uint8_t *data, uint16_t crc);
/**
  * @}
  */
/**
  * @}
  */

/**
  * @}
  */
#ifdef __cplusplus
extern "C"
}
#endif
#endif
