/**
  *********************************************************************************
  *
  * @file    md_conf.h
  * @brief   Enable/Disable the peripheral module.
  *
  * @version V1.0
  * @date    20 Nov 2019
  * @author  AE Team
  * @note
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  *********************************************************************************
  */


#ifndef __MD_CONF_H__
#define __MD_CONF_H__


#define MD_DMA
#define MD_GPIO
#define MD_UART
#define MD_I2C
#define MD_CMU
#define MD_WWDT
#define MD_IWDT
#define MD_RTC
#define MD_FLASH
#define MD_ADC
#define MD_CRC
#define MD_CRYPT
#define MD_TIM
#define MD_SPI
#define MD_TRNG
#define MD_SYSCFG
#define MD_MSC


#ifdef MD_SYSCFG
	#include "md_syscfg.h"
#endif	/* MD_SYSCFG */


#ifdef MD_SPI
	#include "md_spi.h"
#endif	/* MD_SPI */

#ifdef MD_GPIO
	#include "md_gpio.h"
#endif	/* MD_GPIO */

#ifdef MD_DMA
	#include "md_dma.h"
#endif	/* MD_DMA */

#ifdef MD_UART
	#include "md_uart.h"
#endif	/* MD_UART */

#ifdef MD_I2C
	#include "md_i2c.h"
#endif	/* MD_I2C */

#ifdef MD_CMU
	#include "md_cmu.h"
#endif	/* MD_CMU */

#ifdef MD_ADC
	#include "md_adc.h"
#endif	/* MD_ADC */

#ifdef MD_CRC
	#include "md_crc.h"
#endif	/* MD_CRC */

#ifdef MD_CRYPT
	#include "md_crypt.h"
#endif	/* MD_CRYPT */

#ifdef MD_WWDT
	#include "md_wwdt.h"
#endif	/* MD_WWDT */

#ifdef MD_IWDT
	#include "md_iwdt.h"
#endif	/* MD_IWDT */

#ifdef MD_RTC
	#include "md_rtc.h"
#endif	/* MD_RTC */

#ifdef MD_FLASH
	#include "md_flash.h"
#endif	/* MD_FLASH */

#ifdef MD_TIM
	#include "md_timer.h"
#endif	/* MD_TIM */

#ifdef MD_TRNG
	#include "md_trng.h"
#endif	/* MD_TRNG */

#ifdef MD_MSC
	#include "md_msc.h"
#endif /* MD_MSC */


#endif
