/**
  *********************************************************************************
  *
  * @file    main.h
  * @brief   Header file for DEMO
  *
  * @version V1.0
  * @date    17 Nov 2019
  * @author  AE Team
  * @note   
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  *********************************************************************************
  */ 

#ifndef   __MAIN_H__
#define   __MAIN_H__

#include "ald_conf.h"


#define LED1_PORT	GPIOB
#define LED1_PIN	GPIO_PIN_0
#define LED2_PORT	GPIOB
#define LED2_PIN	GPIO_PIN_1

#define UART_PORT_TX	GPIOB
#define UART_PIN_TX	GPIO_PIN_10
#define UART_FUNC_TX	GPIO_FUNC_3
#define UART_PORT_RX	GPIOB
#define UART_PIN_RX	GPIO_PIN_11
#define UART_FUNC_RX	GPIO_FUNC_3


/**
  * @brief Index of the light
  */
typedef enum {
	LIGHT_IDX_1 = 0,		/**< light 1 */
	LIGHT_IDX_2 = 1,		/**< light 2 */
} light_idx_t;

/**
  * @brief Event of the light
  */
typedef enum {
	LIGHT_CTRL_ON     = 0,		/**< ON */
	LIGHT_CTRL_OFF    = 1,		/**< OFF */
	LIGHT_CTRL_TOGGLE = 2,		/**< Toggle */
} light_ctrl_t;

extern void light_init(void);
extern void light_ctrl(light_idx_t idx, light_ctrl_t ctrl);
extern void uart_stdio_init(void);
extern void printf_e(const char *fmt, ...);
#endif
