/**
  *********************************************************************************
  *
  * @file    main.h
  * @brief   Header file for DEMO
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */ 

#ifndef   __MAIN_H__
#define   __MAIN_H__

#include "md_conf.h"

#define UART0_TX_PORT	GPIOB
#define UART0_TX_PIN	MD_GPIO_PIN_10
#define UART0_RX_PORT	GPIOB
#define UART0_RX_PIN	MD_GPIO_PIN_11
#define UARTx		UART0

#define USR_EVENT_IDLE		0x00
#define USR_EVENT_TX_CPLT	0x01
#define USR_EVENT_RX_CPLT	0x02
#define USR_EVENT_TXRX_CPLT	0x03

#define USR_STATE_IDLE		0x00
#define USR_STATE_TX		0x01
#define USR_STATE_RX		0x02

typedef struct {
	uint8_t *tx_buf;
	uint8_t *rx_buf;
	uint32_t tx_cnt;
	uint32_t rx_cnt;
	uint32_t tx_size;
	uint32_t rx_size;
	uint32_t event;
	uint8_t state;
} usr_uart_env_t;

extern usr_uart_env_t env;
#endif
