/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for demo
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#include <string.h>
#include "main.h"

md_uart_init_t h_uart;

uint8_t rx_buf[8] = {0};
uint8_t tx_buf[8] = {0};

/**
  * @brief  Init UART pin
  * @retval None
  */
void md_uart_pin_init(void)
{
	md_gpio_init_t x;
	/* Initialize tx pin */
	x.mode  = MD_GPIO_MODE_OUTPUT;
	x.odos  = MD_GPIO_PUSH_PULL;
	x.pupd  = MD_GPIO_PUSH_UP;
	x.podrv = MD_GPIO_OUT_DRIVE_1;
	x.nodrv = MD_GPIO_OUT_DRIVE_0_1;
	x.flt   = MD_GPIO_FILTER_DISABLE;
	x.type  = MD_GPIO_TYPE_TTL;
	x.func  = MD_GPIO_FUNC_3;
	md_gpio_init(UART0_TX_PORT, UART0_TX_PIN, &x);

	/* Initialize rx pin */
	x.mode  = MD_GPIO_MODE_INPUT;
	x.odos  = MD_GPIO_PUSH_PULL;
	x.pupd  = MD_GPIO_PUSH_UP;
	x.podrv = MD_GPIO_OUT_DRIVE_1;
	x.nodrv = MD_GPIO_OUT_DRIVE_0_1;
	x.flt   = MD_GPIO_FILTER_DISABLE;
	x.type  = MD_GPIO_TYPE_TTL;
	x.func  = MD_GPIO_FUNC_3;
	md_gpio_init(UART0_RX_PORT, UART0_RX_PIN, &x);
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
	uint8_t i = 0;

	/* Configure system clock */
	md_cmu_pll1_config(MD_CMU_PLL1_INPUT_HOSC_3, MD_CMU_PLL1_OUTPUT_72M);
	md_cmu_clock_config(MD_CMU_CLOCK_PLL1, 72000000);
	/* PriorityGroup_2 */
	NVIC_SetPriorityGrouping(5); 
	/* Initialize SysTick Interrupt */
	md_init_1ms_tick();

	/* Enable ALL peripheral */
	SYSCFG_UNLOCK();
	md_cmu_enable_perh_all();
	SYSCFG_LOCK();

	/* Initialize uart communication gpio*/
	md_uart_pin_init();

	md_uart_init_struct(&h_uart);
	md_uart_init(UART0, &h_uart);

	memset(tx_buf, 0x55, sizeof(tx_buf));

	for (i = 0; i < 8; i++) {
		md_uart_set_send_data8(UART0, tx_buf[i]);
		while (!md_uart_is_active_it_tfth(UART0)){};
		md_uart_clear_it_tfth(UART0);
	}

	for (i = 0; i < 8; i++) {
		while (!md_uart_is_active_flag_rfth(UART0)){};
		md_uart_clear_it_tfth(UART0);
		rx_buf[i] = md_uart_recv_data8(UART0);
	}

	while (1) {
		md_delay_1ms(1000);		
	}
}

