/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#include <string.h>
#include "main.h"

/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

md_spi_init_t h_spi;

/**
  * @brief  Initializate pin of spi module.
  * @retval None
  */
void spi_pin_init(void)
{
	md_gpio_init_t x;

	/* Initialize nss pin */
	x.mode  = MD_GPIO_MODE_OUTPUT;
	x.odos  = MD_GPIO_PUSH_PULL;
	x.pupd  = MD_GPIO_PUSH_UP;
	x.podrv = MD_GPIO_OUT_DRIVE_1;
	x.nodrv = MD_GPIO_OUT_DRIVE_1;
	x.flt   = MD_GPIO_FILTER_DISABLE;
	x.type  = MD_GPIO_TYPE_TTL;
	x.func  = MD_GPIO_FUNC_1;
	md_gpio_init(GPIOC, MD_GPIO_PIN_0, &x);

	/* Initialize sck pin */
	x.mode  = MD_GPIO_MODE_OUTPUT;
	x.odos  = MD_GPIO_PUSH_PULL;
	x.pupd  = MD_GPIO_PUSH_UP;
	x.podrv = MD_GPIO_OUT_DRIVE_1;
	x.nodrv = MD_GPIO_OUT_DRIVE_1;
	x.flt   = MD_GPIO_FILTER_DISABLE;
	x.type  = MD_GPIO_TYPE_TTL;
	x.func  = MD_GPIO_FUNC_4;
	md_gpio_init(GPIOC, MD_GPIO_PIN_1, &x);

	/* Initialize miso pin */
	x.mode  = MD_GPIO_MODE_INPUT;
	x.odos  = MD_GPIO_PUSH_PULL;
	x.pupd  = MD_GPIO_PUSH_UP;
	x.podrv = MD_GPIO_OUT_DRIVE_1;
	x.nodrv = MD_GPIO_OUT_DRIVE_1;
	x.flt   = MD_GPIO_FILTER_DISABLE;
	x.type  = MD_GPIO_TYPE_TTL;
	x.func  = MD_GPIO_FUNC_4;
	md_gpio_init(GPIOC, MD_GPIO_PIN_2, &x);

	/* Initialize mosi pin */
	x.mode  = MD_GPIO_MODE_OUTPUT;
	x.odos  = MD_GPIO_PUSH_PULL;
	x.pupd  = MD_GPIO_PUSH_UP;
	x.podrv = MD_GPIO_OUT_DRIVE_1;
	x.nodrv = MD_GPIO_OUT_DRIVE_1;
	x.flt   = MD_GPIO_FILTER_DISABLE;
	x.type  = MD_GPIO_TYPE_TTL;
	x.func  = MD_GPIO_FUNC_4;
	md_gpio_init(GPIOC, MD_GPIO_PIN_3, &x);

	return;
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
	/* Configure system clock */
	md_cmu_clock_config_default();
	/* PriorityGroup_2 */
	NVIC_SetPriorityGrouping(5); 
	/* Initialize SysTick Interrupt */
	md_init_1ms_tick();

	/* Enable ALL peripheral */
	SYSCFG_UNLOCK();
	md_cmu_enable_perh_all();
	SYSCFG_LOCK();
	spi_pin_init();

	memset(&h_spi, 0, sizeof(h_spi));
	md_spi_struct_init(&h_spi);
	md_spi_init(&h_spi);

	/* cs pin set low */
	md_gpio_write_pin(GPIOC, MD_GPIO_PIN_0, 0);
	md_delay_1ms(1);
	md_spi_send_byte_fast(&h_spi, 0x55);
	md_delay_1ms(1);
	md_gpio_write_pin(GPIOC, MD_GPIO_PIN_0, 1);

	while (1) {
		md_delay_1ms(1000);
	}
}

/**
  * @}
  */
/**
  * @}
  */
