/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */ 

#include <string.h>
#include "main.h"

md_i2c_init_t init;

/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/**
  * @brief  Initializate pin of i2c module.
  * @retval None
  */
void i2c_pin_init(void)
{
	md_gpio_init_t x;

	/* Initialize scl pin */
	x.mode  = MD_GPIO_MODE_OUTPUT;
	x.odos  = MD_GPIO_OPEN_DRAIN;
	x.pupd  = MD_GPIO_PUSH_UP;
	x.nodrv = MD_GPIO_OUT_DRIVE_1;
	x.flt   = MD_GPIO_FILTER_DISABLE;
	x.type  = MD_GPIO_TYPE_TTL;
	x.func  = MD_GPIO_FUNC_5;
	md_gpio_init(GPIOB, MD_GPIO_PIN_10, &x);

	/* Initialize sda pin */
	x.mode  = MD_GPIO_MODE_OUTPUT;
	x.odos  = MD_GPIO_OPEN_DRAIN;
	x.pupd  = MD_GPIO_PUSH_UP;
	x.nodrv = MD_GPIO_OUT_DRIVE_1;
	x.flt   = MD_GPIO_FILTER_DISABLE;
	x.type  = MD_GPIO_TYPE_TTL;
	x.func  = MD_GPIO_FUNC_5;
	md_gpio_init(GPIOB, MD_GPIO_PIN_11, &x);

	return;
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
	/* Configure system clock */
	md_cmu_clock_config_default();
	/* PriorityGroup_2 */
	NVIC_SetPriorityGrouping(5); 
	/* Initialize SysTick Interrupt */
	md_init_1ms_tick();

	/* Enable ALL peripheral */
	SYSCFG_UNLOCK();
	md_cmu_enable_perh_all();
	SYSCFG_LOCK();

	i2c_pin_init();
	memset(&init, 0, sizeof(md_i2c_init_t));
	md_i2c_struct_init(&init);
	md_i2c_init(I2C1, &init);

	md_i2c_set_transmit_fifo_reset(I2C1);
	md_i2c_set_slave_addr(I2C1, 0xA0);
	md_i2c_set_start(I2C1);
	md_i2c_set_tx_reg_data(I2C1, 0x55);
	md_i2c_set_stop(I2C1);

	while (1) {
		md_delay_1ms(1000);
	}
}

/**
  * @}
  */
/**
  * @}
  */
