/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#include <string.h>
#include "main.h"

/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Public_Function
  * @{
  */

uint8_t loop  = 0;
uint8_t count = 0;
uint8_t error = 0;
uint32_t plain[16] = {0x3243F6A8, 0x885A308D, 0x313198A2, 0xE0370734,
                      0x3243F6A8, 0x885A308D, 0x313198A2, 0xE0370734,
                      0x3243F6A8, 0x885A308D, 0x313198A2, 0xE0370734,
                      0x3243F6A8, 0x885A308D, 0x313198A2, 0xE0370734};
uint32_t result[16] = {0};
uint32_t expect[16] = {0x925afa80, 0x48a07d7a, 0xd868c5f2, 0xc39468a6,
                       0x1db9bf55, 0xf0be8867, 0x5f04cbc2, 0xfac9578c, 
                       0xf4a47fad, 0x5961e322, 0xd6a04406, 0x01754289, 
                       0x1c22ee2f, 0xa04608aa, 0xc22f6429,0x9240066d};
uint32_t key[4] = {0x2b7e1516, 0x28aed2a6, 0xabf71588, 0x09cf4f3c};
uint32_t ivr[4] = {0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff};

md_crypt_init_t h_crypt;

/* aes cbc key = 128bits
 * input 	32 43 f6 a8 88 5a 30 8d 31 31 98 a2 e0 37 07 34
 *		32 43 f6 a8 88 5a 30 8d 31 31 98 a2 e0 37 07 34
 *		32 43 f6 a8 88 5a 30 8d 31 31 98 a2 e0 37 07 34
 *		32 43 f6 a8 88 5a 30 8d 31 31 98 a2 e0 37 07 34
 * cipher key	2b 7e 15 16 28 ae d2 a6 ab f7 15 88 09 cf 4f 3c
 * iv		f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 fa fb fc fd fe ff
 * refer result	92 5a fa 80 48 a0 7d 7a d8 68 c5 f2 c3 94 68 a6
		1d b9 bf 55 f0 be 88 67 5f 04 cb c2 fa c9 57 8c 
		f4 a4 7f ad 59 61 e3 22 d6 a0 44 06 01 75 42 89 
		1c 22 ee 2f a0 46 08 aa c2 2f 64 29 92 40 06 6d
 */
void test_aes_cbc_128()
{
	uint32_t encrypt_pos  = 0;
	uint32_t result_pos = 0;
	uint32_t decrypt_pos = 0;
	uint32_t loop  = 0;
	uint32_t step  = 0;
	uint32_t count = 0;

	/* Clear lpuart_handle_t structure */
	memset(&h_crypt, 0x0, sizeof(md_crypt_init_t));

	/* AES-CBC mode step = 128 / 32 = 4 */
	step = 4;

	/* Initialize crypt */
	md_crypt_reset();
	md_crypt_init_struct(&h_crypt);
	md_crypt_init(&h_crypt);

	/* Set fifo order */
	md_crypt_set_fifo_order(CRYPT, MD_CRYPT_FIFO_ORDER_3);
	/* Set crypt cbc mode */
	md_crypt_set_mode(CRYPT, MD_CRYPT_MODE_CBC);
	/* Enable fifo */
	md_crypt_enable_fifo(CRYPT);

	/* Set key and iv */
	md_crypt_set_key0(CRYPT, key[3]);
	md_crypt_set_key1(CRYPT, key[2]);
	md_crypt_set_key2(CRYPT, key[1]);
	md_crypt_set_key3(CRYPT, key[0]);

	md_crypt_set_iv0(CRYPT, ivr[3]);
	md_crypt_set_iv1(CRYPT, ivr[2]);
	md_crypt_set_iv2(CRYPT, ivr[1]);
	md_crypt_set_iv3(CRYPT, ivr[0]);
	md_crypt_enable_iv(CRYPT);

	/* Set encrypt function */
	md_crypt_set_encs(CRYPT, MD_CRYPT_SEL_ENCRYPT);

	/* Calculate loop tomes */
	count = sizeof(plain) / (4 * step);

	/* right result equal to refer result */
	while (count--) {
		/* Write data need encrypt to fifo */
		for (loop = 0; loop < step; loop++) {
			md_crypt_set_fifo_data(CRYPT, plain[encrypt_pos]);
			encrypt_pos++;
		}

		while (md_crypt_get_flag_done(CRYPT) == SET);

		/* Get encrypt result */
		for (loop = 0; loop < step; loop++) {
			result[result_pos] = md_crypt_get_fifo_data(CRYPT);
			result_pos++;
		}
	}

	/* Set decrypt function */
	md_crypt_set_encs(CRYPT, MD_CRYPT_SEL_DECRYPT);
	/* Set ivr */
	md_crypt_set_iv0(CRYPT, ivr[3]);
	md_crypt_set_iv1(CRYPT, ivr[2]);
	md_crypt_set_iv2(CRYPT, ivr[1]);
	md_crypt_set_iv3(CRYPT, ivr[0]);
	md_crypt_enable_iv(CRYPT);

	count = sizeof(plain) / (4 * step);
	result_pos = 0;

	/* right result equal to input value*/
	while (count--) {
		/* Write data need encrypt to fifo */
		for (loop = 0; loop < step; loop++) {
			md_crypt_set_fifo_data(CRYPT, expect[decrypt_pos]);
			decrypt_pos++;
		}

		while (md_crypt_get_flag_done(CRYPT) == SET);
		
		/* Get encrypt result */
		for (loop = 0; loop < step; loop++) {
			result[result_pos] = md_crypt_get_fifo_data(CRYPT);
			result_pos++;
		}
	}
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
	/* Configure system clock */
	md_cmu_pll1_config(MD_CMU_PLL1_INPUT_HOSC_3, MD_CMU_PLL1_OUTPUT_72M);
	md_cmu_clock_config(MD_CMU_CLOCK_PLL1, 72000000);
	/* PriorityGroup_2 */
	NVIC_SetPriorityGrouping(5); 
	/* Initialize SysTick Interrupt */
	md_init_1ms_tick();

	/* Enable ALL peripheral */
	SYSCFG_UNLOCK();
	md_cmu_enable_perh_all();
	SYSCFG_LOCK();

	test_aes_cbc_128();

	while (1) {
		md_delay_1ms(1000);
	}
}

/**
  * @}
  */
/**
  * @}
  */
