/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   WDT DEMO
  *
  * @version V1.0
  * @date    17 Nov 2019
  * @author  AE Team
  * @note   
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  *********************************************************************************
  */ 

#include <string.h>
#include "main.h"

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples_WDT
  * @{
  */

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
	/* Initialize ALD */
	ald_cmu_init();
	ald_cmu_pll1_config(CMU_PLL1_INPUT_HOSC_3, CMU_PLL1_OUTPUT_48M);
	ald_cmu_clock_config(CMU_CLOCK_PLL1, 48000000);
	ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);

	/* Enable wwdg and iwdg interrupt */
	ald_mcu_irq_config(WWDG_IRQn, 0, 1, ENABLE);

	/* Initialize WWDT */ 
	ald_wwdt_init(0xFFFF, WWDT_WIN_25, ENABLE);

	/* Start WWDT */
	ald_wwdt_start();

	while (1) {
		ald_delay_ms(1000);
	}
}
/**
  * @}
  */
/**
  * @}
  */

