/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for demo
  *
  * @version V1.0
  * @date    18 Dec 2019
  * @author  AE Team
  * @note   
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  *********************************************************************************
  */ 

#include <string.h>
#include "main.h"

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples_WDT
  * @{
  */
  
/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
	/* Initialize ALD */
	ald_cmu_init();
	ald_cmu_pll1_config(CMU_PLL1_INPUT_HOSC_3, CMU_PLL1_OUTPUT_48M);
	ald_cmu_clock_config(CMU_CLOCK_PLL1, 48000000);
	ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);

	/* Enable wwdg and iwdg interrupt */
	ald_mcu_irq_config(IWDG_IRQn, 0, 1, ENABLE);

	/* Initialize IWDT */
	ald_iwdt_init(0xFFFF, ENABLE);

	/* Start IWDT */
	ald_iwdt_start();

	while (1) {		
		ald_delay_ms(1000);
	}
}
/**
  * @}
  */
/**
  * @}
  */
