/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */ 

#include <string.h>
#include "main.h"


/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */
trng_handle_t h_trng;
uint32_t result;

/**
  * @brief  trng completed callback.
  * @param  arg: Pointer to trng_handle_t structure.
  * @retval None.
  */
void trng_complete(trng_handle_t *arg)
{
	result = ald_trng_get_result(arg);
	return;
}

/**
  * @brief  trng completed callback.
  * @param  arg: Pointer to trng_handle_t structure.
  * @retval None.
  */
void init_complete(trng_handle_t *arg)
{
	return;
}

/**
  * @brief  trng completed callback.
  * @param  arg: Pointer to trng_handle_t structure.
  * @retval None.
  */
void error_complete(trng_handle_t *arg)
{
	return;
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
	/* Initialize ALD */
	ald_cmu_init();
	/* Configure system clock */
	ald_cmu_pll1_config(CMU_PLL1_INPUT_HRC_6, CMU_PLL1_OUTPUT_48M);
	ald_cmu_clock_config(CMU_CLOCK_PLL1, 48000000);

	/* Enable clock */
	ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);
	/* Enable TRNG interrupt */
	ald_mcu_irq_config(TRNG_IRQn, 1, 1, ENABLE);

	memset(&h_trng,0,sizeof(trng_handle_t));

	/* Initialize trng */
	h_trng.perh            = TRNG;
	h_trng.init.data_width = TRNG_DSEL_32B;
	h_trng.init.seed_type  = TRNG_SEED_TYPE_SEED;
	h_trng.init.seed       = 12345678;
	h_trng.init.t_start    = 7;
	h_trng.init.adjc       = 0;
	h_trng.init.posten     = DISABLE;
	h_trng.trng_cplt_cbk   = trng_complete;
	h_trng.init_cplt_cbk   = init_complete;
	h_trng.err_cplt_cbk    = error_complete;
	ald_trng_init(&h_trng);

	/* configure interrupt */
	ald_trng_interrupt_config(&h_trng, TRNG_IT_DAVLD, ENABLE);
	/* Start calculating random */
	TRNG_ENABLE();

	while (1) {
		ald_delay_ms(1000);
	}
}

/**
  * @}
  */
/**
  * @}
  */
