/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */ 

#include <string.h>
#include "main.h"


/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */
trng_handle_t h_trng;
uint32_t result;

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
	/* Initialize ALD */
	ald_cmu_init();
	/* Configure system clock */
	ald_cmu_pll1_config(CMU_PLL1_INPUT_HRC_6, CMU_PLL1_OUTPUT_48M);
	ald_cmu_clock_config(CMU_CLOCK_PLL1, 48000000);

	/* Enable CRC mode clock */
	ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);

	memset(&h_trng,0,sizeof(trng_handle_t));

	/* Initialize trng */
	h_trng.perh            = TRNG;
	h_trng.init.data_width = TRNG_DSEL_32B;
	h_trng.init.seed_type  = TRNG_SEED_TYPE_SEED;
	h_trng.init.seed       = 12345678;
	h_trng.init.t_start    = 7;
	h_trng.init.adjc       = 0;
	h_trng.init.posten     = DISABLE;
	ald_trng_init(&h_trng);

	/* Start calculating random */
	TRNG_ENABLE();

	/* Waiting flag */
	while (!(ald_trng_get_flag_status(&h_trng, TRNG_IF_DAVLD)));
	/* Clear flag */
	ald_trng_clear_flag_status(&h_trng, TRNG_IF_DAVLD);
	/* Get the result */
	result = ald_trng_get_result(&h_trng);

	while (1) {
		while (!(ald_trng_get_flag_status(&h_trng, TRNG_IF_DAVLD)));
		ald_trng_clear_flag_status(&h_trng, TRNG_IF_DAVLD);
		result = ald_trng_get_result(&h_trng);
	}
}

/**
  * @}
  */
/**
  * @}
  */
