/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */ 

#include "main.h"

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */
	
timer_handle_t h_tim;
timer_clock_config_t tim_clock;
timer_oc_init_t tim_ocinit;

/**
  * @brief  Initializate pin of tim module.
  * @retval None
  */
void tim_pin_init(void)
{
	gpio_init_t x;

	/* Initialize tim1 ch1 pin */
	x.mode = GPIO_MODE_OUTPUT;
	x.odos = GPIO_PUSH_PULL;
	x.pupd = GPIO_PUSH_UP;
	x.flt  = GPIO_FILTER_DISABLE;
	x.type = GPIO_TYPE_TTL;
	x.nodrv = GPIO_OUT_DRIVE_6;
	x.podrv = GPIO_OUT_DRIVE_6;
	x.func = GPIO_FUNC_2;
	ald_gpio_init(GPIOB/*GPIOC*/, GPIO_PIN_6, &x);

	x.func = GPIO_FUNC_1;
	ald_gpio_init(GPIOB, GPIO_PIN_11, &x);
	ald_gpio_write_pin(GPIOB, GPIO_PIN_11, 1);
}

/**
  * @brief  This is main function
  * @retval Status
  */
int main()
{
	/* Initialize ALD */
	ald_cmu_init();
        /* Configure system clock */
	ald_cmu_pll1_config(CMU_PLL1_INPUT_HRC_6, CMU_PLL1_OUTPUT_72M);
	ald_cmu_clock_config(CMU_CLOCK_PLL1, 72000000);
	ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);
	
	/* Initialize GP16C4T0 */
	h_tim.perh           = GP16C4T0;
	h_tim.init.prescaler = 71;
	h_tim.init.mode      = TIMER_CNT_MODE_CENTER1;
	h_tim.init.period    = 199;
	h_tim.init.clk_div   = TIMER_CLOCK_DIV1;
	h_tim.init.re_cnt    = 0;
	ald_timer_pwm_init(&h_tim);

        /* Initialize pin */
	tim_pin_init();

	/* Initialize clock source */
	tim_clock.source = TIMER_SRC_INTER;
	ald_timer_config_clock_source(&h_tim, &tim_clock);

	/* Common configuration for all channels */
	tim_ocinit.oc_mode      = TIMER_OC_MODE_PWM1;
        tim_ocinit.oc_polarity  = TIMER_OC_POLARITY_HIGH;
        tim_ocinit.oc_fast_en   = DISABLE;
        tim_ocinit.ocn_polarity = TIMER_OCN_POLARITY_HIGH;
        tim_ocinit.ocn_idle     = TIMER_OCN_IDLE_RESET;
        tim_ocinit.oc_idle      = TIMER_OC_IDLE_RESET;

        /* Set the pulse value for channel 1 */
        tim_ocinit.pulse = 50;
	ald_timer_oc_config_channel(&h_tim, &tim_ocinit, TIMER_CHANNEL_1);
	
	ald_mcu_irq_config(GP16C4T0_IRQn, 1, 1, ENABLE);
	ald_timer_interrupt_config(&h_tim, TIMER_IT_CC1, ENABLE);

   	/* Start input pwm from tim0 channel 1 */
	ald_timer_pwm_start(&h_tim, TIMER_CHANNEL_1);
	
	while(1);
}

void GP16C4T0_Handler(void)
{
	uint32_t reg_cr = h_tim.perh->CON1;
	uint32_t reg = h_tim.perh->IFM;
		
	/* Capture or compare 1 event */
	if (reg & (0X1 << 1)) {
		ald_timer_clear_flag_status(&h_tim, TIMER_FLAG_CC1);
		if (reg_cr & 0X10) {	
			GPIOB->BIR = 0x800U;	 //PB11 toggle
		} 
	}
}

/**
  * @}
  */
/**
  * @}
  */
