/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    27 Mar 2020
  * @author  AE Team
  * @note   
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  *********************************************************************************
  */ 

#include "main.h"

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

lptim_handle_t h_lptim;
lptim_trigger_init_t trigger_config;
lptim_clock_source_init_t clock_config;

/**
  * @brief  Initializate pin of lptim module.
  * @retval None
  */
void lptim_pin_init(void)
{
	gpio_init_t x;
        pis_handle_t y;
	
	
	x.mode  = GPIO_MODE_OUTPUT;
	x.odos  = GPIO_PUSH_PULL;
	x.pupd  = GPIO_PUSH_UP;
	x.nodrv = GPIO_OUT_DRIVE_0_1;
	x.podrv = GPIO_OUT_DRIVE_0_1;
	x.flt   = GPIO_FILTER_DISABLE;
	x.type  = GPIO_TYPE_TTL;
	x.func = GPIO_FUNC_2;
	ald_gpio_init(LPTIMER_OUTPUT_PORT, LPTIMER_OUTPUT_PIN, &x);
	
	x.mode  = GPIO_MODE_INPUT;
	x.odos  = GPIO_PUSH_PULL;
	x.pupd  = GPIO_PUSH_UP;
	x.nodrv = GPIO_OUT_DRIVE_0_1;
	x.podrv = GPIO_OUT_DRIVE_0_1;
	x.flt   = GPIO_FILTER_DISABLE;
	x.type  = GPIO_TYPE_TTL;
	x.func = GPIO_FUNC_1;
	ald_gpio_init(LPTIMER_TRIGGER_PORT, LPTIMER_TRIGGER_PIN, &x);
		
        y.perh = PIS;
        y.init.producer_src  = PIS_GPIO_PIN4;
        y.init.producer_clk  = PIS_CLK_PCLK1;
        y.init.producer_edge = PIS_EDGE_DOWN;
        y.init.consumer_trig = PIS_CH0_LPTIM0_EXT0;
        y.init.consumer_clk  = PIS_CLK_PCLK2;
        y.consumer_ch        = PIS_CH_0;
        ald_pis_create(&y);
}

/**
  * @brief  Compare complete.
  * @param  arg: Pointer to lptim_handle_t structure.
  * @retval None.
  */
void compare_complete(lptim_handle_t *arg)
{
	return;
}

/**
  * @brief  updata complete.
  * @param  arg: Pointer to lptim_handle_t structure.
  * @retval None.
  */
void updata_complete(lptim_handle_t *arg)
{
	return;
}

/**
  * @brief  External trigger complete.
  * @param  arg: Pointer to lptim_handle_t structure.
  * @retval None.
  */
void external_trigger_complete(lptim_handle_t *arg)
{
	ald_lptim_clear_flag_status(&h_lptim,LPTIM_FLAG_EXTTRIG);
}

/**
  * @brief  This is main function
  * @retval Status
  */

int main()
{
	/* Initialize ALD */
	ald_cmu_init();

	ald_cmu_pll1_config(CMU_PLL1_INPUT_HRC_6, CMU_PLL1_OUTPUT_48M);
	ald_cmu_clock_config(CMU_CLOCK_PLL1, 48000000);
        ald_mcu_irq_config(LPTIM0_IRQn, 1, 1, ENABLE);

        /* Enable mode clock */
        ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);

	/* Initialize LPTIM0 */
	lptim_pin_init();

	/* Initialize LPTIM0 */
	h_lptim.perh       = LPTIM0;
	h_lptim.init.psc   = LPTIM_PRESC_1;
	h_lptim.init.arr   = 0x0FFF;
	h_lptim.init.cmp   = 0X0C00;
	h_lptim.init.mode  = LPTIM_MODE_CONTINUOUS;
	h_lptim.init.clock = CMU_LP_PERH_CLOCK_SEL_HRC_1M;
        h_lptim.trig_cbk   = external_trigger_complete;
	h_lptim.trig_cbk   = external_trigger_complete;
	h_lptim.update_cbk = updata_complete;
	h_lptim.cmp_cbk    = compare_complete;
	ald_lptim_pwm_init(&h_lptim);

	/* Initialize clock source */
	clock_config.sel      = LPTIM_CKSEL_INTERNAL;
	clock_config.polarity = LPTIM_CKPOL_RISING;
	ald_lptim_clock_source_config(&h_lptim, &clock_config);

	/* Initialize pulse */
	trigger_config.mode = LPTIM_TRIGEN_FALLING;
        trigger_config.sel  = LPTIM_TRIGSEL_EXT0;
	ald_lptim_trigger_config(&h_lptim, &trigger_config);

        ald_lptim_interrupt_config(&h_lptim, LPTIM_IT_EXTTRIG, ENABLE);
	/* Start pulse start */
	ald_lptim_pwm_start(&h_lptim);

	while(1);
}

/**
  * @}
  */
/**
  * @}
  */
