/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    17 Mar 2020
  * @author  AE Team
  * @note   
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  *********************************************************************************
  */ 

#include "main.h"

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

uint32_t value = 0;
lptim_handle_t h_lptim;
lptim_trigger_init_t _trig;
lptim_clock_source_init_t _clock;

/**
  * @brief  Initializate pin of lptim module.
  * @retval None
  */
void lptim_pin_init(void)
{
	gpio_init_t x;
	
	x.mode  = GPIO_MODE_OUTPUT;
	x.odos  = GPIO_PUSH_PULL;
	x.pupd  = GPIO_PUSH_UP;
	x.nodrv = GPIO_OUT_DRIVE_0_1;
	x.podrv = GPIO_OUT_DRIVE_0_1;
	x.flt   = GPIO_FILTER_DISABLE;
	x.type  = GPIO_TYPE_TTL;
	x.func = GPIO_FUNC_2;
	ald_gpio_init(LPTIMER_TOGGLE_PORT, LPTIMER_TOGGLE_PIN, &x);
}

/**
  * @brief  updata complete.
  * @param  arg: Pointer to lptim_handle_t structure.
  * @retval None.
  */
void updata_complete(lptim_handle_t *arg)
{
	++value;
	return;
}

/**
  * @brief  This is main function
  * @retval Status
  */

int main()
{
	/* Initialize ALD */
	ald_cmu_init();
	/* Configure system clock */
	ald_cmu_pll1_config(CMU_PLL1_INPUT_HRC_6, CMU_PLL1_OUTPUT_48M);
	ald_cmu_clock_config(CMU_CLOCK_PLL1, 48000000);
	
        /* Enable mode clock */
	ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);

        /* Initialize LPTIM0 */
	lptim_pin_init();
	
        ald_mcu_irq_config(LPTIM0_IRQn, 1, 1, ENABLE);
    
	/* Initialize LPTIM0 */
	h_lptim.perh       = LPTIM0;
	h_lptim.init.psc   = LPTIM_PRESC_1;
	h_lptim.init.arr   = 0x0FFF;
        h_lptim.init.clock = CMU_LP_PERH_CLOCK_SEL_LRC;//CMU_LP_PERH_CLOCK_SEL_HRC_1M;
	h_lptim.init.mode  = LPTIM_MODE_CONTINUOUS;
	h_lptim.trig_cbk   = NULL;
	h_lptim.update_cbk = updata_complete;
	h_lptim.cmp_cbk    = NULL;
	ald_lptim_toggle_init(&h_lptim);

	/* Initialize clock source */
	_clock.sel      = LPTIM_CKSEL_INTERNAL;
	_clock.polarity = LPTIM_CKPOL_RISING;
	ald_lptim_clock_source_config(&h_lptim, &_clock);

	/* Initialize toggle */
	_trig.mode = LPTIM_TRIGEN_SW; 
	ald_lptim_trigger_config(&h_lptim, &_trig);

        ald_lptim_interrupt_config(&h_lptim, LPTIM_IT_ARRMAT,ENABLE);
	/* Start LPTIM0 */
	ald_lptim_toggle_start(&h_lptim);

	while(1) {
		ald_delay_ms(1000);
	}
}
/**
  * @}
  */
/**
  * @}
  */
