/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#include <string.h>
#include "main.h"

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

i2s_handle_t h_i2s;
uint16_t tx_buf[32] = {0xdea0, 0xbeef, 0xdea1, 0xbeef, 0xdea2, 0xbeef,
                       0xdea3, 0xbeef, 0xdea4, 0xbeef, 0xdea5, 0xbeef,
                       0xdea6, 0xbeef, 0xdea7, 0xbeef, 0xdea8, 0xbeef,
                       0xdea9, 0xbeef, 0xdeaa, 0xbeef, 0xdeab, 0xbeef,
                       0xdeac, 0xbeef, 0xdead, 0xbeef, 0xdeae, 0xbeef,
                       0xdeaf, 0xbeef};
uint16_t rx_buf[32];

/**
  * @brief  Initializate pin of i2s module.
  * @retval None
  */
void i2s_pin_init(void)
{
	gpio_init_t x;

	/* Initialize WS pin */
	x.mode  = GPIO_MODE_OUTPUT;
	x.odos  = GPIO_PUSH_PULL;
	x.pupd  = GPIO_PUSH_UP;
	x.podrv = GPIO_OUT_DRIVE_6;
	x.nodrv = GPIO_OUT_DRIVE_6;
	x.flt   = GPIO_FILTER_DISABLE;
	x.type  = GPIO_TYPE_CMOS;
	x.func  = GPIO_FUNC_4;
	ald_gpio_init(GPIOC, GPIO_PIN_0, &x);

	/* Initialize SK pin */
	x.mode  = GPIO_MODE_OUTPUT;
	x.odos  = GPIO_PUSH_PULL;
	x.pupd  = GPIO_PUSH_UP;
	x.podrv = GPIO_OUT_DRIVE_6;
	x.nodrv = GPIO_OUT_DRIVE_6;
	x.flt   = GPIO_FILTER_DISABLE;
	x.type  = GPIO_TYPE_CMOS;
	x.func  = GPIO_FUNC_4;
	ald_gpio_init(GPIOC, GPIO_PIN_1, &x);

	/* Initialize SD pin */
	x.mode  = GPIO_MODE_OUTPUT;
	x.odos  = GPIO_PUSH_PULL;
	x.pupd  = GPIO_PUSH_UP;
	x.podrv = GPIO_OUT_DRIVE_6;
	x.nodrv = GPIO_OUT_DRIVE_6;
	x.flt   = GPIO_FILTER_DISABLE;
	x.type  = GPIO_TYPE_CMOS;
	x.func  = GPIO_FUNC_4;
	ald_gpio_init(GPIOC, GPIO_PIN_3, &x);

	return;
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
	/* Initialize ALD */
	ald_cmu_init();
	/* Configure system clock */
	ald_cmu_pll1_config(CMU_PLL1_INPUT_HRC_6, CMU_PLL1_OUTPUT_72M);
	ald_cmu_clock_config(CMU_CLOCK_PLL1, 72000000);	
	ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);
	ald_mcu_irq_config(SPI1_I2S1_IRQn, 3, 3, ENABLE);

	/* clear i2s_handle_t structure */
	memset(&h_i2s, 0x0, sizeof(h_i2s));
	/* Initialize pin */
	i2s_pin_init();
	/* Initialize rx_buf */
	memset(rx_buf, 0x55, sizeof(rx_buf));

	/* Initialize i2s */
	h_i2s.perh            = I2S1;
	h_i2s.init.ch_len     = I2S_WIDE_16;
	h_i2s.init.data_len   = I2S_LEN_16;
	h_i2s.init.polarity   = I2S_INACTIVE_LOW;
	h_i2s.init.standard   = I2S_STD_PHI;
	h_i2s.init.pcm_frame  = I2S_FRAME_SHORT;
	h_i2s.init.ext_clk_en = DISABLE;
	h_i2s.init.ext_clk    = SPI_FIRSTBIT_MSB;
	h_i2s.init.mck_en     = DISABLE;
	h_i2s.init.sampling   = 48 * 1024;
	ald_i2s_init(&h_i2s);

	ald_i2s_master_send_by_it(&h_i2s, tx_buf, 32);
	ald_delay_ms(500);

	ald_i2s_master_recv_by_it(&h_i2s, rx_buf, 32);
	ald_delay_ms(1000);

	while (1) {
		ald_delay_ms(1000);
	}
}

/**
  * @}
  */
/**
  * @}
  */
