/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#include <string.h>
#include "main.h"

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

uint8_t tx_buf[8];
uint8_t rx_buf[8];

i2c_handle_t h_i2c;

/**
  * @brief  Initializate pin of i2c module.
  * @retval None
  */
void i2c_pin_init(void)
{
	gpio_init_t x;

	/* Initialize scl pin */
	x.mode = GPIO_MODE_OUTPUT;
	x.odos = GPIO_OPEN_DRAIN;
	x.pupd = GPIO_PUSH_UP;
	x.nodrv = GPIO_OUT_DRIVE_1;
	x.podrv = GPIO_OUT_DRIVE_1;
	x.flt  = GPIO_FILTER_DISABLE;
	x.type = GPIO_TYPE_TTL;
	x.func = GPIO_FUNC_5;
	ald_gpio_init(I2C_SCL_PORT, I2C_SCL_PIN, &x);

	/* Initialize sda pin */
	x.mode = GPIO_MODE_OUTPUT;
	x.odos = GPIO_OPEN_DRAIN;
	x.pupd = GPIO_PUSH_UP;
	x.nodrv = GPIO_OUT_DRIVE_1;
	x.podrv = GPIO_OUT_DRIVE_1;
	x.flt  = GPIO_FILTER_DISABLE;
	x.type = GPIO_TYPE_TTL;
	x.func = GPIO_FUNC_5;
	ald_gpio_init(I2C_SDA_PORT, I2C_SDA_PIN, &x);

	return;
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
	/* Initialize ALD */
	ald_cmu_init();

	/* Configure system clock */
	ald_cmu_pll1_config(CMU_PLL1_INPUT_HOSC_3, CMU_PLL1_OUTPUT_48M);
	ald_cmu_clock_config(CMU_CLOCK_PLL1, 48000000);

	ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);

	/* clear i2c_handle_t structure */
	memset(&h_i2c, 0, sizeof(i2c_handle_t));
	/* Initialize i2c pin */
	i2c_pin_init();
	/* Initialize tx_buf */
	memset(tx_buf, 0x55, sizeof(tx_buf));

	/* Initialize i2c */
	h_i2c.perh = I2C1;
	h_i2c.init.module	= I2C_MODULE_SLAVE;
	h_i2c.init.addr_mode    = I2C_ADDR_7BIT;
	h_i2c.init.clk_speed    = 100000;
	h_i2c.init.dual_addr    = I2C_DUALADDR_ENABLE;
	h_i2c.init.general_call = I2C_GENERALCALL_ENABLE;
	h_i2c.init.no_stretch   = I2C_NOSTRETCH_DISABLE;
	h_i2c.init.own_addr1    = 0xA0;
	ald_i2c_init(&h_i2c);

	ald_i2c_slave_send(&h_i2c, tx_buf, 8, 1000);
	ald_delay_ms(1000);
	ald_i2c_slave_recv(&h_i2c, rx_buf, 8, 5000);

	while (1) {
		ald_delay_ms(1000);			
	}
}

/**
  * @}
  */
/**
  * @}
  */
