/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */ 

#include "main.h"

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/**
  * @brief  Test main function
  * @retval Status.
  */
uint32_t rising_irq_f = 0;
uint32_t falling_irq_f = 0;
 
uint32_t rising_irq_b = 0;
uint32_t falling_irq_b = 0;
 
extern uint32_t rising_irq;
extern uint32_t falling_irq;
  
int main()
{
	gpio_init_t x;
	exti_init_t exti;

	/* Initialize ALD */
	ald_cmu_init();
	/* Configure system clock */
	ald_cmu_pll1_config(CMU_PLL1_INPUT_HOSC_3, CMU_PLL1_OUTPUT_72M);
	ald_cmu_clock_config(CMU_CLOCK_PLL1, 72000000);
	ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);

	/* Enable external interrupt */
	ald_mcu_irq_config(EXTI2_IRQn, 3, 3, ENABLE);

	/* Initialize GPIO_PIN_1 as input */
	x.mode = GPIO_MODE_INPUT;
	x.odos = GPIO_PUSH_PULL;
	x.pupd = GPIO_PUSH_DOWN;
	x.podrv = GPIO_OUT_DRIVE_1;
	x.nodrv = GPIO_OUT_DRIVE_1;
	x.flt  = GPIO_FILTER_DISABLE;
	x.type = GPIO_TYPE_CMOS;
	x.func = GPIO_FUNC_1;
	ald_gpio_init(GPIOC, GPIO_PIN_2, &x);
	
	x.mode = GPIO_MODE_OUTPUT;
	x.odos = GPIO_PUSH_PULL;
	x.pupd = GPIO_PUSH_DOWN;
	x.podrv = GPIO_OUT_DRIVE_1;
	x.nodrv = GPIO_OUT_DRIVE_1;
	x.flt  = GPIO_FILTER_DISABLE;
	x.type = GPIO_TYPE_CMOS;
	x.func = GPIO_FUNC_1;
	ald_gpio_init(GPIOA, GPIO_PIN_4, &x);
	
	/* Initialize external interrupt */
	exti.filter      = DISABLE;
	exti.cks         = EXTI_FILTER_CLOCK_10K;
	exti.filter_time = 10;
	ald_gpio_exti_init(GPIOC, GPIO_PIN_2, &exti);

	/* Clear interrupt flag */
	ald_gpio_exti_clear_flag_status(GPIO_PIN_2);
	/* Configure interrupt */
	ald_gpio_exti_interrupt_config(GPIO_PIN_2, EXTI_TRIGGER_BOTH_EDGE, ENABLE);

	while (1) {
		rising_irq_f = rising_irq;
		falling_irq_f = falling_irq;
		ald_delay_ms(1000);
		
		rising_irq_b = rising_irq;
		falling_irq_b = falling_irq;
		
		rising_irq_b = rising_irq_b - rising_irq_f;
		falling_irq_b = falling_irq_b - falling_irq_f;
	}
}

/**
  * @}
  */
/**
  * @}
  */
