/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */ 

#include <string.h>
#include "main.h"



/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

timer_handle_t h_tim;
dac_handle_t h_dac;
dac_channel_config_t channel_config;
dma_handle_t hperh;

#define POINT_NUM 32
const uint16_t sine12bit[POINT_NUM] = {
2048 , 2460 , 2856 , 3218 , 3532 , 3786 , 3969 , 4072 ,
4093 , 4031 , 3887 , 3668 , 3382 , 3042 , 2661 , 2255 ,
1841 , 1435 , 1054 , 714  , 428  , 209  , 65   , 3 ,
24   , 127  , 310  , 564  , 878  , 1240 , 1636 , 2048
 };

/**
  * @brief  DAC pin init.
  * @retval None.
  */
void dac_gpio_init(void)
{
	gpio_init_t x;
	memset(&x, 0, sizeof(gpio_init_t));

	x.mode = GPIO_MODE_OUTPUT;
	x.func = GPIO_FUNC_0;
	ald_gpio_init(DAC0_OUT_PORT, DAC0_OUT_PIN, &x);
	ald_gpio_init(DAC1_OUT_PORT, DAC1_OUT_PIN, &x);
}

/**
  * @brief  Initializate DMA chanel0 and channel1.
  * @retval None
  */
void init_dma(void)
{
	hperh.perh = DMA0;
	ald_dma_config_struct(&hperh.config);
	
	hperh.config.src     = (void *)sine12bit;
	hperh.config.dst     = (void *)(&DAC0->CH0DATA); 
	hperh.config.size    = POINT_NUM;
	hperh.config.data_width = DMA_DATA_SIZE_HALFWORD;
	hperh.config.src_inc = DMA_DATA_INC_HALFWORD;
	hperh.config.dst_inc = DMA_DATA_INC_NONE;
	hperh.config.R_power = DMA_R_POWER_1;
	
	hperh.config.msel    = DMA_MSEL_TIMER0;
	hperh.config.msigsel = DMA_MSIGSEL_TIMER_UPDATE;
	
	hperh.cplt_cbk       = NULL;
	hperh.cplt_arg       = NULL;
	hperh.err_cbk        = NULL;
	hperh.err_arg        = NULL;
	hperh.config.channel = 0;
	ald_dma_config_basic(&hperh);
	
	hperh.perh = DMA0;
	ald_dma_config_struct(&hperh.config);
	
	hperh.config.src     = (void *)sine12bit;;
	hperh.config.dst     = (void *)(&DAC0->CH1DATA); 
	hperh.config.size    = POINT_NUM;
	hperh.config.data_width = DMA_DATA_SIZE_HALFWORD;
	hperh.config.src_inc = DMA_DATA_INC_HALFWORD;
	hperh.config.dst_inc = DMA_DATA_INC_NONE;
	hperh.config.R_power = DMA_R_POWER_1;
	
	hperh.config.msel    = DMA_MSEL_TIMER0;
	hperh.config.msigsel = DMA_MSIGSEL_TIMER_UPDATE;
	
	hperh.cplt_cbk       = NULL;
	hperh.cplt_arg       = NULL;
	hperh.err_cbk        = NULL;
	hperh.err_arg        = NULL;
	hperh.config.channel = 1;
	ald_dma_config_basic(&hperh);
}

/**
  * @brief  Initializate DMA chanel0 and channel1.
  * @retval None
  */
void timer_init(void)
{
	/* Initialize AD16C4T0 */
	h_tim.perh           = GP16C4T0;
	h_tim.init.prescaler = 71;
	h_tim.init.mode      = TIMER_CNT_MODE_UP;
	h_tim.init.period    = 99;
	h_tim.init.clk_div   = TIMER_CLOCK_DIV1;
	h_tim.init.re_cnt    = 0;
        h_tim.capture_cbk    = NULL;
	ald_timer_base_init(&h_tim);
	ald_timer_base_start(&h_tim);
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
	/* Initialize ALD */
	ald_cmu_init();
	/* Configure system clock */
	ald_cmu_pll1_config(CMU_PLL1_INPUT_HOSC_3, CMU_PLL1_OUTPUT_48M);
	ald_cmu_clock_config(CMU_CLOCK_PLL1, 48000000);

	/* Enable mode clock */
	ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);
	/* DAC pin Initialize */
	dac_gpio_init();
	
	memset(&h_dac, 0, sizeof(dac_handle_t));
	memset(&channel_config, 0, sizeof(dac_channel_config_t));

	/* Initialize DAC */
	h_dac.perh            = DAC0;
	h_dac.init.conv_mode  = DAC_CONV_MODE_CONTINUOUS;
	h_dac.init.out_mode   = DAC_OUTPUT_PIN;
	h_dac.init.refresh    = DAC_REFRESH_8;
	h_dac.init.div        = DAC_PRES_DIV_128;
	h_dac.init.ch0_reset  = DISABLE;
	h_dac.init.o_ctrl_pis = DISABLE;
	h_dac.init.sine       = DISABLE;
	h_dac.init.diff       = DISABLE;
	h_dac.init.n_ref      = DAC_NEG_REF_VSS;
	h_dac.init.p_ref      = DAC_POS_REF_VDD;
	h_dac.cbk             = NULL;
	ald_dac_init(&h_dac);
	
	/* Config dac channel 0 */
	channel_config.enable     = ENABLE;
	channel_config.trigger    = DAC_TRIGGER_BY_DATA;
	channel_config.refresh_en = DISABLE;
	ald_dac_channel_config(&h_dac, &channel_config, DAC_CHANNEL_0);
	ald_dac_channel_config(&h_dac, &channel_config, DAC_CHANNEL_1);

	init_dma();
	
	timer_init();
	GP16C4T0->DMAEN |= (1 << 0);

	while (1) {

	}
}

/**
  * @}
  */
/**
  * @}
  */
