/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#include <string.h>
#include "main.h"


/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

crypt_handle_t h_crypt;
uint8_t count = 0;
uint8_t error = 0;

/**
  * @brief  crypt completed callback.
  * @param  arg: Pointer to crypt_handle_t structure.
  * @retval None.
  */
void crypt_complete(crypt_handle_t *arg)
{
	ald_crypt_clear_flag_status(arg, CRYPT_FLAG_DONE);
	++count;
	return;
}

/**
  * @brief  crypt error callback.
  * @param  arg: Pointer to crypt_handle_t structure.
  * @retval None.
  */
void error_complete(crypt_handle_t *arg)
{
	++error;
	return;
}

void test_des_cbc_128()
{
	uint32_t plain_buffer[16] = {	0x3243F6A8, 0x885A308D, 0x313198A2, 0xE0370734,
					0x3243F6A8, 0x885A308D, 0x313198A2, 0xE0370734,
					0x3243F6A8, 0x885A308D, 0x313198A2, 0xE0370734,
					0x3243F6A8, 0x885A308D, 0x313198A2, 0xE0370734};
	uint32_t result_buffer[16] = {0};

	uint32_t expect_buffer[16] = {	0xc72641ae, 0x57e9c64b, 0x5fc04cea, 0xd961d1dd , 
					0xcb020e7c, 0x5ead10b2, 0x187b3649, 0x0bba3412, 
					0x0b493f8f, 0x8e4443fb, 0x2b0b9337, 0xb1db07d0, 
					0x15582d81, 0x898b5bbf, 0x8074cf1d, 0x66607c7d};

	uint32_t key_buf[2]   = {0x2b7e1516, 0x28aed2a6};
	uint32_t ivr_buf[2]   = {0xf0f1f2f3, 0xf4f5f6f7};
	/* Clear lpuart_handle_t structure */
	memset(&h_crypt, 0x0, sizeof(crypt_handle_t));

	/* Initialize crypt */
	h_crypt.perh           = CRYPT;
	h_crypt.init.mode      = CRYPT_MODE_CBC;//CRYPT_MODE_CBC
	h_crypt.init.key       = CRYPT_DES_KEYS_1;
	h_crypt.init.type      = DATA_32_BIT;
	h_crypt.crypt_cplt_cbk = crypt_complete;
	h_crypt.err_cplt_cbk   = error_complete;
	ald_crypt_init(&h_crypt);

	/* Start AES encrypt,right result_buffer equal to expect_buffer */
	ald_crypt_write_key(&h_crypt,key_buf,KEY_2_LEN);
	ald_crypt_write_ivr(&h_crypt,ivr_buf,IV_2_LEN);
 	ald_crypt_encrypt(&h_crypt,(uint8_t*)plain_buffer, (uint8_t*)result_buffer, sizeof(plain_buffer));

	/* Start AES decrypt,right result_buffer equal to plain_buffer */	
	ald_crypt_write_key(&h_crypt,key_buf,KEY_2_LEN);
	ald_crypt_write_ivr(&h_crypt,ivr_buf,IV_2_LEN);
 	ald_crypt_decrypt(&h_crypt,(uint8_t*)expect_buffer, (uint8_t*)result_buffer, sizeof(expect_buffer));	
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
	/* Initialize ALD */
	ald_cmu_init();
	/* Configure system clock */
	ald_cmu_pll1_config(CMU_PLL1_INPUT_HRC_6, CMU_PLL1_OUTPUT_48M);
	ald_cmu_clock_config(CMU_CLOCK_PLL1, 48000000);
	/* Enable CRC mode clock */
	ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);

	/* des cbc mode 128bits key case */
	test_des_cbc_128();

	while (1) {
		ald_delay_ms(1000);
	}
}
/**
  * @}
  */
/**
  * @}
  */
