/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */ 

#include <string.h>
#include "main.h"


/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

crypt_handle_t h_crypt;
uint8_t count = 0;
uint8_t error = 0;

/**
  * @brief  crypt completed callback.
  * @param  arg: Pointer to crypt_handle_t structure.
  * @retval None.
  */
void crypt_complete(crypt_handle_t *arg)
{
	ald_crypt_clear_flag_status(arg, CRYPT_FLAG_DONE);
	++count;
	return;
}

/**
  * @brief  crypt error callback.
  * @param  arg: Pointer to crypt_handle_t structure.
  * @retval None.
  */
void error_complete(crypt_handle_t *arg)
{
	++error;
	return;
}

void test_aes_gcm_128()
{
	uint32_t plain_buffer[12] = {
		0x34f16d95, 0xf72bbf85, 0x21685ca8, 0xc2763539, 
		0xae4efa8d, 0xe536a9b1, 0x3874e477, 0xe4e75aa4, 
		0x00cdf79c, 0x844480cd, 0x50d90ed3, 0x41ecc678};
	uint32_t result_buffer[12] = {0};
	uint32_t expect_buffer[12] = { 
		0x79f5bb40, 0x20f27af2, 0xd26fb456, 0xfb2b23ab,
		0x7ce9e479, 0xb83f05ee, 0x5338c530, 0xc89afb89,
		0x5f37cf4f, 0xe4a92218, 0x10a7690e, 0x8b093971};
	uint32_t AADATA[5] = {
			0xce1b0a8b, 0xd2090db1, 0x9c52f0b8, 0x36a1e745, 0xf87fdb84};
	uint32_t key_buf[4]   = {0xca214226, 0xa3273356, 0x4b4e6f9f, 0x84683c4e};
	uint32_t ivr_buf[4]   = {0xd4d3b130, 0xaf2ff43d, 0x8aa86cec, 0x2};
	uint32_t tag[4];
//	uint32_t exp_tag[4]   =  {0x4d92a606, 0xfe847574, 0x9579dc64, 0x760cd551};	
	/* Clear lpuart_handle_t structure */
	memset(&h_crypt, 0x0, sizeof(crypt_handle_t));

	/* Initialize crypt */
	h_crypt.perh           = CRYPT;
	h_crypt.init.mode      = CRYPT_MODE_CTR;//CRYPT_MODE_ECB
	h_crypt.init.key       = CRYPT_AES_BITS_128;
	h_crypt.init.type      = DATA_32_BIT;
	h_crypt.crypt_cplt_cbk = crypt_complete;
	h_crypt.err_cplt_cbk   = error_complete;
	ald_crypt_init(&h_crypt);

	/* Start DES encrypt,right result_buffer equal to expect_buffer */
	ald_crypt_write_key(&h_crypt,key_buf,KEY_4_LEN);
	ald_crypt_write_ivr(&h_crypt,ivr_buf,IV_4_LEN);
 	ald_crypt_encrypt(&h_crypt,(uint8_t*)plain_buffer, (uint8_t*)result_buffer, 48);

	/* Start gcm verify,right tag equal to exp_tag */
	ald_crypt_gcm_verify(&h_crypt,(uint8_t*)result_buffer,48,(uint8_t*)AADATA,20,(uint8_t*)tag);

	/* Start DES decrypt,result_buffer equal to plain_buffer  */
	ald_crypt_write_key(&h_crypt,key_buf,KEY_4_LEN);
	ald_crypt_write_ivr(&h_crypt,ivr_buf,IV_4_LEN);
	ald_crypt_gcm_verify(&h_crypt,(uint8_t*)result_buffer,48,(uint8_t*)AADATA,20,(uint8_t*)tag);
	ald_crypt_write_ivr(&h_crypt,ivr_buf,IV_4_LEN);
 	ald_crypt_decrypt(&h_crypt,(uint8_t*)expect_buffer, (uint8_t*)result_buffer, 48);
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
	/* Initialize ALD */
	ald_cmu_init();
	/* Configure system clock */
	ald_cmu_pll1_config(CMU_PLL1_INPUT_HRC_6, CMU_PLL1_OUTPUT_48M);
	ald_cmu_clock_config(CMU_CLOCK_PLL1, 48000000);
	/* Enable CRC mode clock */
	ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);

	/* Aes gcm mode 128bits key case */
	test_aes_gcm_128();

	while (1) {
		ald_delay_ms(1000);
	}
}
/**
  * @}
  */
/**
  * @}
  */
