/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    07 Nov 2017
  * @author  AE Team
  * @note
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  *********************************************************************************
  */

#include "main.h"
#include <string.h>

  
/** @addtogroup Projects_Examples_ALD
  * @{
  */


/** @addtogroup Public_Function
  * @{
  */

crc_handle_t h_crc;
uint8_t crc_buf[12] = {0};
uint32_t result = 0;

/**
  * @brief  calculate completed callback.
  * @param  arg: Pointer to crc_handle_t structure.
  * @retval None.
  */
void calculate_complete(crc_handle_t *arg)
{
	result = result^0xffff;
	return;
}

/**
  * @brief  calculate error callback.
  * @param  arg: Pointer to crc_handle_t structure.
  * @retval None.
  */
void error_complete(crc_handle_t *arg)
{
	return;
}

/**
  * @brief  Calculate CRC using DMA.
  * @note   Result must be 0x77E3.
  * @retval None.
  */
void test_crc32_dma()
{
	int32_t i;
	uint8_t crc_buf_temp[11] = {0x19,0x00,0x43,0x05,0x01,0x00,0x00,0x00,0x00,0x17,0x00};
	/* Clear crc_handle_t structure */
	memset(&h_crc, 0x0, sizeof(crc_handle_t));
	
	for(i = 0;i < 11; i++) {
		crc_buf[i] = crc_buf_temp[i];
	}
	
	/* Initialize CRC */
	h_crc.perh = CRC;
	h_crc.init.mode = CRC_MODE_CCITT;
	h_crc.init.seed = 0xffff;
	h_crc.init.data_rev = ENABLE;
	h_crc.init.data_inv = DISABLE;
	h_crc.init.chs_rev = ENABLE;
	h_crc.init.chs_inv = DISABLE;
	
	h_crc.cal_cplt_cbk = calculate_complete;
	h_crc.err_cplt_cbk = error_complete;
	ald_crc_init(&h_crc);
	
	/* start calculate by dma and the result is 0x77E3 */
	ald_crc_calculate_by_dma(&h_crc, crc_buf, &result, 11, 1);
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{

	/* Initialize ALD */
	ald_cmu_init();
	ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);
	test_crc32_dma();
	
	while (1) {
		ald_delay_ms(1000);
	}
}

/**
  * @} Public_Function
  */

/**
  * @} Projects_Examples_ALD
  */
