/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */ 

#include <string.h>
#include "main.h"



/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */
  
uint8_t warm_en = 0;
uint8_t out_result = 0;
uint8_t result = 0;
acmp_handle_t h_acmp;

/**
  * @brief  ACMP gpio init.
  * @param  None.
  * @retval None.
  */
void acmp_gpio_init(void)
{
	gpio_init_t x;

	memset(&x, 0, sizeof(gpio_init_t));

	x.mode = GPIO_MODE_INPUT;
	x.func = GPIO_FUNC_0;
	x.type = GPIO_TYPE_CMOS;
	ald_gpio_init(ACMP0_IN_PORT, ACMP0_IN0_PIN, &x);
	ald_gpio_init(ACMP0_IN_PORT, ACMP0_IN1_PIN, &x);

	x.mode = GPIO_MODE_OUTPUT;
	x.func = GPIO_FUNC_4;
	ald_gpio_init(ACMP0_OUT0_PORT, ACMP0_OUT0_PIN, &x);
}

/**
  * @brief  Warm-up complete.
  * @param  arg: Pointer to acmp_handle_t structure.
  * @retval None.
  */
void warm_up_complete(acmp_handle_t *arg)
{
	++warm_en;
	return;
}

/**
  * @brief  Edge complete.
  * @param  arg: Pointer to acmp_handle_t structure.
  * @retval None.
  */
void edge_complete(acmp_handle_t *arg)
{
	out_result = ald_acmp_out_result(arg);
	return;
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
	/* Initialize ALD */
	ald_cmu_init();
	/* Configure system clock */
	ald_cmu_pll1_config(CMU_PLL1_INPUT_HRC_6, CMU_PLL1_OUTPUT_48M);
	ald_cmu_clock_config(CMU_CLOCK_PLL1, 48000000);

	/* Enable mode clock */
	ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);
	/* Enable ACMP0 interrupt */
	ald_mcu_irq_config(ACMP0_IRQn, 1, 1, ENABLE);
	/* ACMP gpio init */
	acmp_gpio_init();

	/* Initialize ACMP0 */
	h_acmp.perh                 = ACMP0;
	h_acmp.init.mode            = ACMP_HIGH_POWER;
	h_acmp.init.warm_time       = ACMP_64_PCLK;
	h_acmp.init.hystsel         = ACMP_HYST_22;
	h_acmp.init.p_port          = ACMP_POS_CH0;
	h_acmp.init.n_port          = ACMP_NEG_CH1;
	h_acmp.init.inactval        = ACMP_INACTVAL_LOW;
	h_acmp.init.out_inv         = DISABLE;
	h_acmp.init.edge            = ACMP_EDGE_ALL;
	h_acmp.init.vdd_level       = 63;
	h_acmp.acmp_warmup_cplt_cbk = warm_up_complete;
	h_acmp.acmp_edge_cplt_cbk   = edge_complete;
	ald_acmp_init(&h_acmp);

	/* Initialize ACMP0 output*/
	ald_acmp_out_config(&h_acmp, ENABLE);
	/* Enable edge interrupt */
	ald_acmp_interrupt_config(&h_acmp, ACMP_IT_EDGE, ENABLE);

	while (1) {
		result = ald_acmp_out_result(&h_acmp);
		ald_delay_ms(1000);
	}
}

/**
  * @}
  */
/**
  * @}
  */
