/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    17 Nov 2020
  * @author  AE Team
  * @note   
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  *********************************************************************************
  */ 

#include <string.h>
#include "main.h"


/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

uint32_t tick0;
uint32_t tick1;
uint32_t time;


/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
	uint32_t i;
	uint8_t com;

	/* Initialize ALD */
	ald_cmu_init();
	/* Get first tick */
	tick0 = ald_get_tick();

	/* do something */
	for (i = 0; i < 0xff; ++i) {
		com = 1;
		com = i + com + 3;
		com = com + 24;
	}

	/* Get second tick */
	tick1 = ald_get_tick();
	/* time = (tick1 -tick0) * 1 / flck */
	time  = tick1 - tick0;

	while (1) {
		ald_delay_ms(1000);
	}
}

/**
  * @}
  */
/**
  * @}
  */
