/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */ 

#include <string.h>
#include <rtthread.h>
#include "main.h"


#define THREAD_STACK_SIZE	512
#define THREAD_PRIORITY		8

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

static struct rt_semaphore *sem;
static uint8_t t1_count, t2_count;
static struct rt_thread *t1, *t2, *worker;

static void thread1_entry(void* parameter)
{
	rt_err_t result;

	while (1) {
		result = rt_sem_take(sem, RT_WAITING_FOREVER);
		if (result != RT_EOK)
			return;

		++t1_count;
		rt_kprintf("thread1: got semaphore, count: %d\n", t1_count);
	}
}

static void thread2_entry(void* parameter)
{
	rt_err_t result;

	while (1) {
		result = rt_sem_take(sem, RT_WAITING_FOREVER);
		if (result != RT_EOK)
			return;

		++t2_count;
		rt_kprintf("thread2: got semaphore, count: %d\n", t2_count);
	}
}

static void worker_thread_entry(void* parameter)
{
	rt_thread_delay(100);

	while (1){
		rt_sem_release(sem);
		rt_thread_delay(100);
	}
}


/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
	t1_count = 0;
	t2_count = 0;

	sem = rt_sem_create("sem", 0, RT_IPC_FLAG_FIFO);
	//sem = rt_sem_create("sem", 0, RT_IPC_FLAG_PRIO);
	if (sem == RT_NULL)
		return 0;

	t1 = rt_thread_create("t1", thread1_entry, RT_NULL,
			THREAD_STACK_SIZE, THREAD_PRIORITY + 1, 5);
	if (t1 != RT_NULL)
		rt_thread_startup(t1);

	t2 = rt_thread_create("t2", thread2_entry, RT_NULL,
			THREAD_STACK_SIZE, THREAD_PRIORITY - 1, 5);
	if (t2 != RT_NULL)
		rt_thread_startup(t2);

	worker = rt_thread_create("worker", worker_thread_entry, RT_NULL,
				THREAD_STACK_SIZE, THREAD_PRIORITY, 5);
	if (worker != RT_NULL)
		rt_thread_startup(worker);

	return 0;
}

/**
  * @}
  */
/**
  * @}
  */
