/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#include <string.h>
#include <rtthread.h>
#include "main.h"


/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
	uint8_t *ptr1, *ptr2, *ptr3, *ptr4, *ptr5;

	ptr1 = (uint8_t *)rt_malloc(1);
	ptr2 = (uint8_t *)rt_malloc(13);
	ptr3 = (uint8_t *)rt_malloc(32);
	ptr4 = (uint8_t *)rt_malloc(127);
	ptr5 = (uint8_t *)rt_calloc(4, 12);	/* malloc(4 * 12), and then set them to zero. */

	if (ptr1 != NULL)
		memset(ptr1, 1, 1);
	if (ptr2 != NULL)
		memset(ptr2, 2, 13);
	if (ptr3 != NULL)
		memset(ptr3, 3, 31);
	if (ptr4 != NULL)
		memset(ptr4, 4, 127);

	rt_free(ptr5);
	rt_free(ptr4);
	rt_free(ptr3);
	rt_free(ptr2);
	rt_free(ptr1);

	return 0;
}

/**
  * @}
  */
/**
  * @}
  */
