/**********************************************************************************
 *
 * @file    main.h
 * @brief   header file of main.c
 *
 * @date    20 Jul 2022
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          20 Jul 2022     AE Team         the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef __MAIN_H__
#define __MAIN_H__

/* Includes -------------------------------------------------------*/
#include <stdio.h>
#include <stdint.h>
#include "es32f0943.h"

#include "md_tick.h"

#include "md_rcu.h"
#include "md_syscfg.h"
#include "md_fc.h"

#include "md_gpio.h"
#include "md_calc.h"
#include "md_rtc.h"

#include "md_exti.h"
#include "md_uart.h"
#include "md_spi.h"
#include "md_i2c.h"
#include "md_timer.h"
#include "md_wwdt.h"
#include "md_iwdt.h"
#include "md_adc.h"
#include "md_cmp.h"

#include "bsp_led.h"
#include "bsp_key.h"

#ifdef MAIN_GLOBALS
    #define MAIN_EXT
#else
    #define MAIN_EXT extern
#endif

#define START_PAGE      0x2000            // flash page for parameters
#define SYSTEM_CLOCK    4000000           // master clock
#define SYSTEM_CLOCKMHZ    (SYSTEM_CLOCK/1000000)
#define TIMER_PERIOD_1KHZ  (SYSTEM_CLOCK/1000)    // 1khz general purpose interrupt
/* Public Functions -----------------------------------------------------------*/
MAIN_EXT volatile uint32_t TmrSystem;
MAIN_EXT uint8_t gu8DispTital;


#define cal_TimeTick(time,sys_time)  ((time)>(sys_time)?0xffffffff-(time)+1+(sys_time):(sys_time)-(time))  // 10ms Time tick
#define cal_usTick(time,sys_time)    ((time)>(sys_time)?0xffff-(time)+1+(sys_time):(sys_time)-(time))      // 1us Time tick
#define GetSystemTime()              (TmrSystem)

#define CheckTime(time)    cal_TimeTick(time,TmrSystem)
#define UpdateTime(time)  ((time)=TmrSystem)
/* Public Init Structure ------------------------------------------------------*/
/* Public Macros --------------------------------------------------------------*/
/* Public Constants -----------------------------------------------------------*/
/* Private Variables ----------------------------------------------------------*/
/* Private Macros -------------------------------------------------------------*/
/* Private Constants-----------------------------------------------------------*/
/* Private Functions ----------------------------------------------------------*/


#endif
/******************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/

