/*********************************************************
*Copyright (C), 2023, Shanghai Eastsoft Microelectronics Co., Ltd.
 * @文件名:    rtc.h
 * @作  者:    AE Team
 * @版  本:    V1.00
 * @日  期:    2023/02/01
 * @描  述:    DS1302驱动头文件
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
#ifndef DS1302_H
#define DS1302_H

#include <stdint.h>
#include "md_gpio.h"

#define DS1302_RST_PORT     GPIOD
#define DS1302_IO_PORT      GPIOD
#define DS1302_CLK_PORT     GPIOD

#define DS1302_RST_PIN      MD_GPIO_PIN_14
#define DS1302_IO_PIN       MD_GPIO_PIN_12
#define DS1302_CLK_PIN      MD_GPIO_PIN_11

#define KY1302_CLK_PT

#define DS1302_CLK_HIGH()   md_gpio_set_pin_high(DS1302_CLK_PORT, DS1302_CLK_PIN)
#define DS1302_CLK_LOW()    md_gpio_set_pin_low(DS1302_CLK_PORT, DS1302_CLK_PIN)
#define DS1302_IO_HIGH()    md_gpio_set_pin_high(DS1302_IO_PORT, DS1302_IO_PIN)
#define DS1302_IO_LOW()     md_gpio_set_pin_low(DS1302_IO_PORT, DS1302_IO_PIN)
#define DS1302_RST_HIGH()   md_gpio_set_pin_high(DS1302_RST_PORT, DS1302_RST_PIN)
#define DS1302_RST_LOW()    md_gpio_set_pin_low(DS1302_RST_PORT, DS1302_RST_PIN)

#define DS1302_IO_IN()      md_gpio_set_pin_mode(DS1302_IO_PORT, DS1302_IO_PIN, MD_GPIO_MODE_INPUT)
#define DS1302_IO_OUT()     md_gpio_set_pin_mode(DS1302_IO_PORT, DS1302_IO_PIN, MD_GPIO_MODE_OUTPUT)
#define DS1302_IO_IS_HIGH() md_gpio_get_inputpinset(DS1302_IO_PORT, DS1302_IO_PIN)

#define SEC_ADR                         0x80
#define MIN_ADR                         0x82
#define HOU_ADR                         0x84
#define DAY_ADR                         0x86
#define MON_ADR                         0x88
#define YEA_ADR                         0x8C

#define WRITE_SW_ADR                    0x8E //写保护地址

#define CHARGE_ADR                      0x90 //充电写地址<读为0x91>
#define TCS_ON                          0xA0
#define TCS_OFF                         0x00
#define DS_DIODE_ONE                    0x04 //VCC2和VCC1之间1个二极管充电
#define DS_DIODE_TWO                    0x08 //VCC2和VCC1之间2个二极管充电
#define DS_OFF                          0x00 //充电被禁止
#define CS_RES_NO                       0x01 //无电阻
#define CS_RES_2K                       0x01 //2K电阻
#define CS_RES_4K                       0x02 //4K电阻
#define CS_RES_8K                       0x03 //8K电阻


#define HOURLY_24                       0x00
#define HOURLY_12                       0x01

#define HOURLY_PM                       0x00
#define HOURLY_AM                       0x01

typedef struct
{
    uint8_t year;     //取值00~99
    uint8_t month;
    uint8_t day;
    uint8_t hour;
    uint8_t minute;
    uint8_t second;
    uint8_t wday;
} type_time;

uint8_t bcd_dec(uint8_t bcd);
uint8_t dec_bcd(uint8_t dec);
void ds1302_write(uint8_t adr, uint8_t dat);
uint8_t ds1302_read(uint8_t adr);
void ds1302_init(void);
void ds1302_write_time(void);
void ds1302_read_time(void);
uint8_t week_conversion(uint8_t year, uint8_t month, uint8_t day);
void ds1302_write_ram(uint8_t *buf, uint8_t len);
void ds1302_read_ram(uint8_t *buf, uint8_t len);

extern type_time t_time;

#endif
