/**********************************************************************************
 *
 * @file    main.c
 * @brief   main C file
 *
 * @date    19 Sep 2022
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          19 Sep 2022     AE Team         the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes -------------------------------------------------------------------*/
#include "main.h"

/** @addtogroup Projects_Examples_MD
  * @{
  */

/* Private types --------------------------------------------------------------*/

md_gpio_inittypedef GPIOC_PIN4_Init =    /**< GPIOC init structure */
{
    MD_GPIO_PIN_4,
    MD_GPIO_MODE_FUNCTION,
    MD_GPIO_PULL_FLOATING,
    MD_GPIO_PULL_UP,
    MD_GPIO_DS_8mA,
    MD_GPIO_AF0
};

md_gpio_inittypedef GPIOC_PIN3_Init =    /**< GPIOC init structure */
{
    MD_GPIO_PIN_3,
    MD_GPIO_MODE_FUNCTION,
    MD_GPIO_OUTPUT_PUSHPULL,
    MD_GPIO_PULL_UP,
    MD_GPIO_DS_8mA,
    MD_GPIO_AF0
};

md_gpio_inittypedef GPIOD_PIN0_Init =    /**< GPIOD init structure */
{
    MD_GPIO_PIN_0,
    MD_GPIO_MODE_FUNCTION,
    MD_GPIO_OUTPUT_OPENDRAIN,
    MD_GPIO_PULL_UP,
    MD_GPIO_DS_8mA,
    MD_GPIO_AF1
};

md_gpio_inittypedef GPIOD_PIN1_Init =    /**< GPIOD init structure */
{
    MD_GPIO_PIN_1,
    MD_GPIO_MODE_FUNCTION,
    MD_GPIO_OUTPUT_OPENDRAIN,
    MD_GPIO_PULL_UP,
    MD_GPIO_DS_8mA,
    MD_GPIO_AF1
};

/**
  * @brief I2C init structure.
  */
md_i2c_inittypedef I2C_Init =
{
    CLK100kHz16M,
    0x50 << 1,
         MD_I2C_ADDRESSINGMODE_7BIT,
         MD_I2C_DUALADDRESS_DISABLE,
         0x20,
         MD_I2C_ADDR2_NOMASK
};

md_rcu_init_typedef rcu_initStruct =    /**< RCU init structure */
{
    MD_RCU_MPRE_MCO_DIV_1,
    MD_RCU_MCO_DISABLE,
    MD_RCU_HRCDIV_DIV_1,
    MD_RCU_PPRE_HCLK_DIV_1,
    MD_RCU_HPRE_SYSCLK_DIV_1,
    MD_RCU_SYSCLK_HRC,
    (RCU_CON_HRCON_MSK),
};

md_uart_init_typedef uart_initStruct =    /**< UART init structure */
{
    MD_UART_BAUDRATE_115200,
    MD_UART_LCON_LSB_FIRST,
    MD_UART_LCON_PS_EVEN,
    MD_UART_LCON_STOP_1,
    MD_UART_LCON_DLS_8,
};

/**
* @brief  main.
* @param  None
* @retval None
*/
int main(void)
{
    uint8_t rxbuf[255], ii;
    md_rcu_init_set(RCU, &rcu_initStruct);

    md_rcu_enable_i2c1(RCU);
    md_rcu_enable_uart1(RCU);
    md_rcu_enable_gpiod(RCU);
    md_rcu_enable_gpioc(RCU);

    md_gpio_init(GPIOC, &GPIOC_PIN4_Init);
    md_gpio_init(GPIOC, &GPIOC_PIN3_Init);
    md_gpio_init(GPIOD, &GPIOD_PIN0_Init);
    md_gpio_init(GPIOD, &GPIOD_PIN1_Init);

    md_uart_init(UART1, &uart_initStruct);
    md_i2c_init(I2C1, &I2C_Init);
    md_tick_init(MD_SYSTICK_CLKSRC_MCU);
//    while(md_i2c_is_active_flag_busy(I2C1)==0);
    md_i2c_slave_rece(I2C1, 16, &rxbuf[0]);

    for (ii = 0; ii < 16; ii++)
        printf("rxbuf[%d]:%x\r\n", ii, rxbuf[ii]);

    while (1)
    {
        md_tick_waitms(100, 1);

        if ((ii++) % 2)
        {
            ii = 0;
            bsp_led3_on();
            bsp_led4_off();
        }
        else
        {
            bsp_led3_off();
            bsp_led4_on();
        }
    }
}

/**
  * @brief  Uart sendchar.
  * @param  arg: char to be sent.
  * @retval data to be sent.
  */
uint8_t  sendchar(uint8_t ch)
{
    while (UART1->STAT & (UART_STAT_TFFULL_MSK));  /* Tx FIFO full */

    UART1->TXBUF = ch;            /* Sent byte */
    return (ch);
}

/**
  * @} Projects_Examples_MD
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
